# Environment Configuration Setup

This document explains how to configure the environment variables for the Hisbuu application.

## Quick Start

1. Copy the example file:
   ```bash
   cp .env.example .env
   ```

2. Edit the `.env` file with your actual configuration values:
   ```bash
   nano .env
   # or use your preferred editor
   ```

3. Update the database credentials and other settings as needed.

## Environment Variables

### Database Configuration

| Variable | Description | Default | Example |
|----------|-------------|----------|---------|
| `DB_HOST` | Database server hostname | `localhost` | `localhost` or `127.0.0.1` |
| `DB_PORT` | Database server port | `3307` | `3307` or `3306` |
| `DB_NAME` | Database name | `hisub_om` | `hisub_om` |
| `DB_USER` | Database username | `root` | `hisbuu_user` |
| `DB_PASS` | Database password | (empty) | `your_secure_password` |

### Application Configuration

| Variable | Description | Default | Example |
|----------|-------------|----------|---------|
| `APP_ENV` | Application environment | `development` | `development`, `staging`, `production` |
| `APP_DEBUG` | Enable debug mode | `true` | `true` or `false` |
| `APP_BASE_URL` | Base URL of the application | `https://hisub.dhofar.digital/public` | `http://localhost/hisbuu-staging/public` |

### Session Configuration

| Variable | Description | Default | Example |
|----------|-------------|----------|---------|
| `SESSION_LIFETIME` | Session lifetime in seconds | `1800` | `1800` (30 minutes) |

### Security

| Variable | Description | Default | Example |
|----------|-------------|----------|---------|
| `CSRF_TOKEN_LENGTH` | Length of CSRF tokens | `32` | `32` |

## Production Deployment

When deploying to production:

1. **Never commit `.env` to version control** - it's already in `.gitignore`
2. Use strong, unique database passwords
3. Set `APP_ENV=production`
4. Set `APP_DEBUG=false`
5. Update `APP_BASE_URL` to your production URL
6. Set appropriate `SESSION_LIFETIME` for your security requirements

## Local Development

For local development (XAMPP/WAMP):

```env
DB_HOST=localhost
DB_PORT=3307
DB_NAME=hisub_om
DB_USER=root
DB_PASS=
APP_ENV=development
APP_DEBUG=true
APP_BASE_URL=http://localhost/hisbuu-staging/public
```

## Troubleshooting

### Database Connection Failed

If you see "Database connection error":

1. Check that MySQL/XAMPP is running
2. Verify the port number (XAMPP typically uses 3307)
3. Confirm database exists and credentials are correct
4. Check `error_log` for detailed error messages

### Variables Not Loading

If environment variables aren't being read:

1. Ensure `.env` file exists in the project root
2. Check file permissions (should be readable by web server)
3. Verify the file is named `.env` (not `.env.txt`)

## Security Notes

- The `.env` file contains sensitive information
- Never share it publicly
- Add it to your `.gitignore` file (already included)
- Use different `.env` files for different environments
- Rotate passwords regularly in production
