<?php
require_once __DIR__ . '/auth_check.php';
require_once __DIR__ . '/policy.php';
require_once __DIR__ . '/helpers.php';
require_once __DIR__ . '/settings.php';
require_once __DIR__ . '/../config/db.php';

require_login();
$role = current_user_role();

// Fetch branding settings
$appName = app_setting('branding.app_name', 'Hisbuu');
$adminLogo = app_setting('branding.admin_logo', '');
// Fallback to legacy setting if new one is empty
if ($adminLogo === '') {
    $adminLogo = app_setting('admin.header_logo', '');
}
// Convert storage path to URL
if ($adminLogo !== '' && strpos($adminLogo, 'storage/') === 0) {
    $adminLogo = file_url($adminLogo);
}

// helper
function nav_active($needle) {
    $path = $_SERVER['SCRIPT_NAME'] ?? '';
    return strpos($path, $needle) !== false ? ' active fw-semibold' : '';
}

function section_open(array $needles) {
    $path = $_SERVER['SCRIPT_NAME'] ?? '';
    foreach ($needles as $needle) {
        if (strpos($path, $needle) !== false) {
            return true;
        }
    }
    return false;
}

// capabilities
$can_finance   = can_manage_finance($role);
$can_review    = can_review_submissions($role) || can_approve_submissions($role);
$can_admin     = in_array($role, ['Administrator','Super Administrator'], true);
$can_drivers   = function_exists('can_manage_drivers') ? can_manage_drivers($role) : $can_admin;
$can_users     = function_exists('can_manage_users') ? can_manage_users($role) : $can_admin;
$can_partner   = function_exists('can_manage_partner_daily') ? can_manage_partner_daily($role) : ($can_finance || $can_admin);
$can_lookups   = function_exists('can_manage_lookups') ? can_manage_lookups($role) : $can_admin;
$can_assets    = function_exists('can_manage_assets') ? can_manage_assets($role) : $can_admin;

// visibility rules
$show_pending      = ($can_finance || $can_review || $can_admin);
$show_submissions  = ($can_finance || $can_review || $can_admin || $role === 'Supervisor');
$show_partner_data = ($can_partner || $can_finance || $can_admin);
$show_bank_matcher = ($can_finance || $can_admin);
$show_adjustments  = ($can_finance || $can_admin);
$show_drivers      = ($can_drivers && $role !== 'Finance Administrator');
$show_users        = ($can_users);
$show_assets       = ($can_assets);
$show_lookups      = ($can_lookups);
$show_payouts      = ($can_finance || $can_admin);

// which sections should auto open
$assets_open  = section_open(['assets.php', 'assign_assets', 'assign_assets_bulk']);
$drivers_open = section_open(['driver_list', 'driver_doc_sets_review']);
$submissions_open = section_open(['submissions_list', 'submissions_summary']);
$lookups_open = section_open([
    'projects_manage',
    'cities_manage',
    'zones_manage',
    'nationalities_manage',
    'salary_schemes_manage',
    'settings'
]);
$payouts_open = section_open(['payouts.php']);
?>

<link rel="stylesheet"
      href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

<style>
.admin-topbar-logo {
  max-height: 28px;
  max-width: 120px;
  object-fit: contain;
}
:root {
    --hisbuu-red: #C20F2F;
    --hisbuu-red-dark: #9d0d27;
    --sidebar-width: 250px;
    --sidebar-width-collapsed: 70px;
  }

  body {
    padding-top: 55px;
    padding-left: var(--sidebar-width);
  }

  .hisbuu-topbar {
    background: var(--hisbuu-red);
    left: 0;
    width: 100%;
  }

  .hisbuu-sidebar {
    position: fixed;
    top: 0;
    left: 0;
    width: var(--sidebar-width);
    bottom: 0;
    background: var(--hisbuu-red);
    color: #fff;
    overflow-y: auto;
    z-index: 1030;
    transition: width 0.2s ease-in-out;
  }

  .hisbuu-sidebar .sidebar-brand {
    padding: 12px 16px;
    display: flex;
    align-items: center;
    gap: 10px;
    background: #b20d28;
  }

  .hisbuu-sidebar .sidebar-brand img {
    max-height: 30px;
    max-width: 180px;
    object-fit: contain;
  }

  .hisbuu-sidebar .sidebar-brand-logo {
    width: 30px;
    height: 30px;
    border-radius: 15px;
    background: #ffffff;
    color: #C20F2F;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 700;
    font-size: 18px;
  }

  .hisbuu-sidebar .sidebar-brand-text {
    font-size: 17px;
    font-weight: 600;
    color: #ffffff;
  }

  .hisbuu-sidebar .menu-title {
    padding: 8px 16px 4px;
    font-size: 11px;
    text-transform: uppercase;
    opacity: 0.8;
  }

  .hisbuu-sidebar .nav-link {
    color: #fbd8d9;
    padding: 8px 16px;
    font-size: 14px;
    display: flex;
    align-items: center;
    border-radius: 0;
  }

  .hisbuu-sidebar .nav-link .icon {
    width: 22px;
    text-align: center;
    margin-right: 8px;
    font-size: 15px;
  }

  .hisbuu-sidebar .nav-link.active,
  .hisbuu-sidebar .nav-link:hover {
    background: var(--hisbuu-red-dark);
    color: #fff;
  }

  .hisbuu-sidebar .nav-link .chevron {
    margin-left: auto;
    font-size: 11px;
  }

  .hisbuu-sidebar .submenu .nav-link {
    font-size: 13px;
    padding-top: 6px;
    padding-bottom: 6px;
  }

  body.sidebar-collapsed {
    padding-left: var(--sidebar-width-collapsed) !important;
  }

  body.sidebar-collapsed .hisbuu-sidebar {
    width: var(--sidebar-width-collapsed);
  }

  body.sidebar-collapsed .hisbuu-sidebar .menu-title {
    display: none;
  }

  body.sidebar-collapsed .hisbuu-sidebar .nav-link .label {
    display: none;
  }

  body.sidebar-collapsed .hisbuu-sidebar .nav-link .icon {
    margin-right: 0;
  }

  body.sidebar-collapsed .hisbuu-sidebar .submenu {
    display: none !important;
  }

  body.sidebar-collapsed .hisbuu-sidebar .sidebar-brand-text {
    display: none;
  }

  body.sidebar-collapsed .hisbuu-sidebar .sidebar-brand {
    justify-content: center;
  }

  body.sidebar-collapsed .hisbuu-topbar {
    padding-left: var(--sidebar-width-collapsed);
  }

  body:not(.sidebar-collapsed) .hisbuu-topbar {
    padding-left: var(--sidebar-width);
  }

  @media (max-width: 991.98px) {
    body {
      padding-left: 0;
      padding-top: 55px;
    }
    .hisbuu-sidebar {
      transform: translateX(-260px);
      width: var(--sidebar-width);
    }
    .hisbuu-sidebar.open {
      transform: translateX(0);
    }
    body.sidebar-collapsed {
      padding-left: 0 !important;
    }
    .hisbuu-topbar {
      padding-left: 0;
    }
  }
  nav.navbar.navbar-dark.fixed-top.hisbuu-topbar {
    min-height: 55px;
}
</style>

<nav class="navbar navbar-dark fixed-top hisbuu-topbar">
  <div class="container-fluid">
    <button class="navbar-toggler d-lg-none" type="button"
            onclick="document.querySelector('.hisbuu-sidebar').classList.toggle('open');">
      <span class="navbar-toggler-icon"></span>
    </button>

    <div class="d-flex align-items-center d-lg-none">
      <?php if ($adminLogo): ?>
        <img src="<?php echo e($adminLogo); ?>" alt="Logo" class="admin-topbar-logo">
      <?php else: ?>
        <div class="d-flex align-items-center justify-content-center bg-white rounded-circle"
             style="width:28px;height:28px;color:#C20F2F;font-weight:700;font-size:17px;">
          <?php echo e(substr($appName, 0, 1)); ?>
        </div>
      <?php endif; ?>
    </div>

    <div class="d-flex align-items-center gap-2 ms-auto">
      <button type="button"
              class="btn btn-sm btn-outline-light d-none d-lg-inline-flex"
              onclick="document.body.classList.toggle('sidebar-collapsed');">
        <i class="bi bi-layout-sidebar-inset"></i>
      </button>

      <span class="me-2 small text-white d-none d-sm-inline">
        Role: <strong><?php echo e($role); ?></strong>
      </span>
      <a href="<?php echo base_url('logout.php'); ?>" class="btn btn-sm btn-outline-light">Logout</a>
    </div>
  </div>
</nav>

<div class="hisbuu-sidebar">

  <div class="sidebar-brand">
    <?php if ($adminLogo): ?>
      <img src="<?php echo e($adminLogo); ?>" alt="Logo">
    <?php else: ?>
      <div class="sidebar-brand-logo"><?php echo e(substr($appName, 0, 1)); ?></div>
      <span class="sidebar-brand-text"><?php echo e($appName); ?></span>
    <?php endif; ?>
  </div>

  <div class="menu-title">Main</div>
  <a href="<?php echo base_url('dashboard.php'); ?>"
     class="nav-link<?php echo nav_active('dashboard'); ?>">
    <span class="icon"><i class="bi bi-speedometer2"></i></span>
    <span class="label">Dashboard</span>
  </a>

  <?php if ($show_pending): ?>
    <a href="<?php echo base_url('admin/pending_approvals.php'); ?>"
       class="nav-link<?php echo nav_active('pending_approvals'); ?>">
      <span class="icon"><i class="bi bi-hourglass-split"></i></span>
      <span class="label">Pending approvals</span>
    </a>
  <?php endif; ?>

  <?php if ($show_submissions): ?>
    <div class="menu-title">Submissions</div>
    <a class="nav-link d-flex align-items-center"
       data-bs-toggle="collapse"
       href="#submissionsMenu"
       role="button"
       aria-expanded="<?php echo $submissions_open ? 'true' : 'false'; ?>"
       aria-controls="submissionsMenu">
      <span class="icon"><i class="bi bi-inbox"></i></span>
      <span class="label">Submissions</span>
      <span class="chevron ms-auto">
        <i class="bi <?php echo $submissions_open ? 'bi-chevron-down' : 'bi-chevron-right'; ?>"></i>
      </span>
    </a>
    <div class="collapse submenu <?php echo $submissions_open ? 'show' : ''; ?>" id="submissionsMenu">
      <a href="<?php echo base_url('admin/submissions_list.php'); ?>"
         class="nav-link<?php echo nav_active('submissions_list'); ?>">
        <span class="icon"><i class="bi bi-list-ul"></i></span>
        <span class="label">Submissions list</span>
      </a>
      <a href="<?php echo base_url('admin/submissions_summary.php'); ?>"
         class="nav-link<?php echo nav_active('submissions_summary'); ?>">
        <span class="icon"><i class="bi bi-calendar3"></i></span>
        <span class="label">Monthly summary</span>
      </a>
    </div>
  <?php endif; ?>

  <?php if ($show_partner_data): ?>
    <a href="<?php echo base_url('admin/data_entry.php'); ?>"
       class="nav-link<?php echo nav_active('data_entry'); ?>">
      <span class="icon"><i class="bi bi-diagram-3"></i></span>
      <span class="label">Partner data</span>
    </a>
  <?php endif; ?>

  <?php if ($show_adjustments): ?>
    <a href="<?php echo base_url('admin/adjustments_list.php'); ?>"
       class="nav-link<?php echo nav_active('adjustments_list'); ?>">
      <span class="icon"><i class="bi bi-sliders"></i></span>
      <span class="label">Adjustments</span>
    </a>
  <?php endif; ?>

  <?php if ($show_bank_matcher): ?>
    <a href="<?php echo base_url('admin/bank_upload.php'); ?>"
       class="nav-link<?php echo nav_active('bank_upload'); ?>">
      <span class="icon"><i class="bi bi-bank"></i></span>
      <span class="label">Bank matcher</span>
    </a>
  <?php endif; ?>

  <?php if ($show_payouts): ?>
    <div class="menu-title">Payouts</div>
    <a href="<?php echo base_url('admin/payouts/payouts.php'); ?>"
       class="nav-link<?php echo nav_active('payouts.php'); ?>">
      <span class="icon"><i class="bi bi-cash-stack"></i></span>
      <span class="label">Payouts</span>
    </a>
  <?php endif; ?>

  <?php if ($show_assets): ?>
    <div class="menu-title">Assets</div>
    <a class="nav-link d-flex align-items-center"
       data-bs-toggle="collapse"
       href="#assetsMenu"
       role="button"
       aria-expanded="<?php echo $assets_open ? 'true' : 'false'; ?>"
       aria-controls="assetsMenu">
      <span class="icon"><i class="bi bi-box-seam"></i></span>
      <span class="label">Assets</span>
      <span class="chevron ms-auto">
        <i class="bi <?php echo $assets_open ? 'bi-chevron-down' : 'bi-chevron-right'; ?>"></i>
      </span>
    </a>
    <div class="collapse submenu <?php echo $assets_open ? 'show' : ''; ?>" id="assetsMenu">
      <a href="<?php echo base_url('admin/assets.php'); ?>"
         class="nav-link<?php echo nav_active('assets.php'); ?>">
        <span class="icon"><i class="bi bi-box-seam"></i></span>
        <span class="label">Manage catalog</span>
      </a>
      <a href="<?php echo base_url('admin/assign_assets.php'); ?>"
         class="nav-link<?php echo nav_active('assign_assets'); ?>">
        <span class="icon"><i class="bi bi-arrow-left-right"></i></span>
        <span class="label">Assign assets</span>
      </a>
      <a href="<?php echo base_url('admin/assign_assets_bulk.php'); ?>"
         class="nav-link<?php echo nav_active('assign_assets_bulk'); ?>">
        <span class="icon"><i class="bi bi-file-earmark-spreadsheet"></i></span>
        <span class="label">Bulk assign (CSV)</span>
      </a>
    </div>
  <?php endif; ?>

  <?php if ($show_drivers): ?>
    <div class="menu-title">Drivers</div>
    <a class="nav-link d-flex align-items-center"
       data-bs-toggle="collapse"
       href="#driversMenu"
       role="button"
       aria-expanded="<?php echo $drivers_open ? 'true' : 'false'; ?>"
       aria-controls="driversMenu">
      <span class="icon"><i class="bi bi-people"></i></span>
      <span class="label">Drivers</span>
      <span class="chevron ms-auto">
        <i class="bi <?php echo $drivers_open ? 'bi-chevron-down' : 'bi-chevron-right'; ?>"></i>
      </span>
    </a>
    <div class="collapse submenu <?php echo $drivers_open ? 'show' : ''; ?>" id="driversMenu">
      <a href="<?php echo base_url('admin/driver_list.php'); ?>"
         class="nav-link<?php echo nav_active('driver_list'); ?>">
        <span class="icon"><i class="bi bi-people"></i></span>
        <span class="label">Manage drivers</span>
      </a>
      <a href="<?php echo base_url('admin/driver_doc_sets_review.php'); ?>"
         class="nav-link<?php echo nav_active('driver_doc_sets_review'); ?>">
        <span class="icon"><i class="bi bi-file-earmark-check"></i></span>
        <span class="label">KYD review</span>
      </a>
    </div>
  <?php endif; ?>

  <?php if ($show_users): ?>
    <div class="menu-title">Users</div>
    <a href="<?php echo base_url('admin/users_manage.php'); ?>"
       class="nav-link<?php echo nav_active('users_manage'); ?>">
      <span class="icon"><i class="bi bi-person-gear"></i></span>
      <span class="label">Users</span>
    </a>
  <?php endif; ?>

  <?php if ($show_lookups): ?>
    <div class="menu-title">Lookups & Settings</div>
    <a class="nav-link d-flex align-items-center"
       data-bs-toggle="collapse"
       href="#lookupsMenu"
       role="button"
       aria-expanded="<?php echo $lookups_open ? 'true' : 'false'; ?>"
       aria-controls="lookupsMenu">
      <span class="icon"><i class="bi bi-list-check"></i></span>
      <span class="label">Lookups & Settings</span>
      <span class="chevron ms-auto">
        <i class="bi <?php echo $lookups_open ? 'bi-chevron-down' : 'bi-chevron-right'; ?>"></i>
      </span>
    </a>
    <div class="collapse submenu <?php echo $lookups_open ? 'show' : ''; ?>" id="lookupsMenu">
      <a href="<?php echo base_url('admin/projects_manage.php'); ?>"
         class="nav-link<?php echo nav_active('projects_manage'); ?>">
        <span class="icon"><i class="bi bi-diagram-2"></i></span>
        <span class="label">Projects</span>
      </a>
      <a href="<?php echo base_url('admin/cities_manage.php'); ?>"
         class="nav-link<?php echo nav_active('cities_manage'); ?>">
        <span class="icon"><i class="bi bi-geo-alt"></i></span>
        <span class="label">Cities</span>
      </a>
      <a href="<?php echo base_url('admin/zones_manage.php'); ?>"
         class="nav-link<?php echo nav_active('zones_manage'); ?>">
        <span class="icon"><i class="bi bi-grid-1x2"></i></span>
        <span class="label">Zones</span>
      </a>
      <a href="<?php echo base_url('admin/nationalities_manage.php'); ?>"
         class="nav-link<?php echo nav_active('nationalities_manage'); ?>">
        <span class="icon"><i class="bi bi-flag"></i></span>
        <span class="label">Nationalities</span>
      </a>
      <a href="<?php echo base_url('admin/salary_schemes_manage.php'); ?>"
         class="nav-link<?php echo nav_active('salary_schemes_manage'); ?>">
        <span class="icon"><i class="bi bi-wallet2"></i></span>
        <span class="label">Salary schemes</span>
      </a>
      <a href="<?php echo base_url('admin/settings.php'); ?>"
         class="nav-link<?php echo nav_active('settings'); ?>">
        <span class="icon"><i class="bi bi-gear"></i></span>
        <span class="label">Settings</span>
      </a>
    </div>
  <?php endif; ?>

</div>
