<?php
// public/driver/debug_status.php
require_once __DIR__ . '/../../includes/driver_auth.php';
require_once __DIR__ . '/../../config/db.php';
require_once __DIR__ . '/../../includes/helpers.php';

if (session_status() === PHP_SESSION_NONE) session_start();
$driver_id = $_SESSION['driver']['id'] ?? 0;

echo "<h1>Debug Document Status</h1>";
echo "<p>Driver ID: $driver_id</p>";

// Fetch all docs
$sql = "SELECT * FROM driver_documents WHERE driver_id = $driver_id";
$res = $conn->query($sql);

echo "<table border='1' cellpadding='5'><tr><th>ID</th><th>Set ID</th><th>Type ID</th><th>Side</th><th>Path</th></tr>";
while($row = $res->fetch_assoc()){
    echo "<tr>";
    foreach($row as $k => $v) echo "<td>$v</td>";
    echo "</tr>";
}
echo "</table>";

// Check Sets
echo "<h3>Document Sets (The Logic Check)</h3>";
$sql = "SELECT group_key, status FROM driver_doc_sets WHERE driver_id = $driver_id";
$res = $conn->query($sql);
while($row = $res->fetch_assoc()){
    echo "Found Set: <strong>" . $row['group_key'] . "</strong> (Status: " . $row['status'] . ")<br>";
}

echo "<h3>Mandatory Check</h3>";
$mandatories = ['civil_id', 'license', 'vehicle_reg', 'selfie'];
foreach($mandatories as $key) {
    $set = $conn->query("SELECT id FROM driver_doc_sets WHERE driver_id=$driver_id AND group_key='$key'")->fetch_object();
    if (!$set) {
        echo "<div style='color:red; font-weight:bold'>MISSING SET: $key</div>";
        continue;
    }
    
    // Check files
    $front = $conn->query("SELECT id FROM driver_documents WHERE doc_set_id={$set->id} AND side='front'")->num_rows;
    $back  = $conn->query("SELECT id FROM driver_documents WHERE doc_set_id={$set->id} AND side='back'")->num_rows;
    
    echo "$key: Front=$front, Back=$back ... ";
    
    if ($key == 'selfie') {
        if ($front > 0) echo "<span style='color:green'>OK</span><br>";
        else echo "<span style='color:red'>MISSING FILE</span><br>";
    } else {
        if ($front > 0 && $back > 0) echo "<span style='color:green'>OK</span><br>";
        else echo "<span style='color:red'>MISSING FILE (Need Front AND Back)</span><br>";
    }
}
?>