<?php

// /includes/driver_auth.php

require_once __DIR__ . '/session_config.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

function driver_logged_in(): bool {
    if (!isset($_SESSION['driver']) || empty($_SESSION['driver']['id'])) {
        return false;
    }

    // Verify driver is still active in database
    // This checks every request to ensure deactivated drivers are immediately logged out
    global $conn;
    require_once __DIR__ . '/../config/db.php';

    $driver_id = (int)$_SESSION['driver']['id'];
    $stmt = $conn->prepare("SELECT status FROM drivers WHERE id=? LIMIT 1");
    $stmt->bind_param('i', $driver_id);
    $stmt->execute();
    $result = $stmt->get_result()->fetch_assoc();

    if (!$result || strtolower($result['status']) !== 'active') {
        // Driver is inactive or deleted, destroy session
        driver_logout();
        return false;
    }

    return true;
}

function require_driver_login(): void {
    if (!driver_logged_in()) {
        header('Location: login.php', true, 302);
        exit;
    }
}

function redirect_driver_if_logged_in(): void {
    if (driver_logged_in()) {
        header('Location: dashboard.php', true, 302);
        exit;
    }
}

function current_driver_id(): int {
    return (int)($_SESSION['driver']['id'] ?? 0);
}

function driver_logout(): void {
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    unset($_SESSION['driver']);
    session_regenerate_id(true);
}

if (!function_exists('current_driver_partner_id')) {
    function current_driver_partner_id(): ?string {
        if (session_status() === PHP_SESSION_NONE) {
            session_start();
        }
        return $_SESSION['driver']['partner_id'] ?? null;
    }
}
