<?php
// includes/policy.php
// Centralized role normalization and permission helpers for Hisbuu.
// Keep this file minimal, explicit, and deny-by-default.

if (!function_exists('norm_role')) {
    function norm_role($role) {
        $r = strtolower(trim((string)$role));
        $map = [
            'super administrator'   => 'Super Administrator',
            'super admin'           => 'Super Administrator',
            'administrator'         => 'Administrator',
            'admin'                 => 'Administrator',
            'finance administrator' => 'Finance Administrator',
            'finance admin'         => 'Finance Administrator',
            'supervisor'            => 'Supervisor',
        ];
        return $map[$r] ?? ($role ?: null);
    }
}

if (!function_exists('has_role')) {
    function has_role($role, array $allowed) {
        $role = norm_role($role);
        return in_array($role, $allowed, true);
    }
}

/** Submissions: list/review queue */
if (!function_exists('can_review_submissions')) {
    function can_review_submissions($role) {
        return has_role($role, [
            'Supervisor',
            'Administrator',
            'Finance Administrator',
            'Super Administrator'
        ]);
    }
}

/** Submissions: approve/reject */
if (!function_exists('can_approve_submissions')) {
    function can_approve_submissions($role) {
        return has_role($role, [
            'Administrator',
            'Finance Administrator',
            'Super Administrator'
        ]);
    }
}

/** Drivers: create/edit/list */
if (!function_exists('can_manage_drivers')) {
    function can_manage_drivers($role) {
        return has_role($role, [
            'Supervisor',
            'Administrator',
            'Super Administrator'
        ]);
    }
}

/** Assets: create/edit/assign */
if (!function_exists('can_manage_assets')) {
    function can_manage_assets($role) {
        return has_role($role, [
            'Administrator',
            'Super Administrator'
        ]);
    }
}

/** Projects: prefixes, lookups ownership */
if (!function_exists('can_manage_projects')) {
    function can_manage_projects($role) {
        return has_role($role, [
            'Administrator',
            'Super Administrator'
        ]);
    }
}

/** Lookups: cities, zones, types, nationalities, salary schemes */
if (!function_exists('can_view_lookups')) {
    function can_view_lookups($role) {
        return has_role($role, [
            'Supervisor',
            'Administrator',
            'Finance Administrator',
            'Super Administrator'
        ]);
    }
}

/** Finance pages: reconciliation, finance-only views */
if (!function_exists('can_manage_finance')) {
    function can_manage_finance($role) {
        return has_role($role, [
            'Finance Administrator',
            'Super Administrator'
        ]);
    }
}

/** Partner daily: view totals and reconciliation lists */
if (!function_exists('can_view_partner_daily')) {
    function can_view_partner_daily($role) {
        return has_role($role, [
            'Finance Administrator',
            'Administrator',
            'Super Administrator'
        ]);
    }
}

/** Partner daily: data entry/edit */
if (!function_exists('can_manage_partner_daily')) {
    function can_manage_partner_daily($role) {
        // Allow Admin and Super Admin to manage; Finance can edit fields in some cases as requested
        return has_role($role, [
            'Administrator',
            'Finance Administrator',
            'Super Administrator'
        ]);
    }
}

/** System users management */
if (!function_exists('can_manage_users')) {
    function can_manage_users($role) {
        return has_role($role, ['Super Administrator']);
    }
}

/** Global settings */
if (!function_exists('can_edit_settings')) {
    function can_edit_settings($role) {
        return has_role($role, ['Super Administrator']);
    }
}

// backward compatibility alias
if (!function_exists('can_manage_lookups') && function_exists('can_view_lookups')) {
    function can_manage_lookups($role) {
        return can_view_lookups($role);
    }
}
