<?php
require_once __DIR__ . '/../../includes/admin_bootstrap.php';

$role = strtolower(get_current_role() ?? '');
$can_edit = in_array($role, ['super administrator','administrator','finance administrator'], true);
$csrf = get_csrf_token();

$ok = ''; $err = '';

// Create / Update
if ($can_edit && $_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['csrf']) && hash_equals($csrf, $_POST['csrf'])) {
  $name = trim($_POST['name'] ?? '');
  $type = ($_POST['type'] ?? '') === 'positive' ? 'positive' : 'negative';
  $is_active = isset($_POST['is_active']) ? 1 : 0;
  $id = isset($_POST['id']) && ctype_digit($_POST['id']) ? (int)$_POST['id'] : 0;

  if ($name === '') {
    $err = 'Name is required.';
  } else {
    if ($id > 0) {
      $st = $conn->prepare("UPDATE adjustment_categories SET name=?, type=?, is_active=? WHERE id=?");
      $st->bind_param('ssii', $name, $type, $is_active, $id);
      if ($st->execute()) $ok = 'Category updated.';
      else $err = 'Update failed.';
    } else {
      $st = $conn->prepare("INSERT INTO adjustment_categories(name, type, is_active) VALUES(?,?,?)");
      $st->bind_param('ssi', $name, $type, $is_active);
      if ($st->execute()) $ok = 'Category created.';
      else $err = 'Create failed. Possibly duplicate name for this type.';
    }
  }
}

// Fetch list
$list = [];
$q = $conn->query("SELECT id, name, type, is_active, created_at FROM adjustment_categories ORDER BY type, name");
while ($r = $q->fetch_assoc()) $list[] = $r;
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Adjustment Categories | Hisbuu</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<?php include __DIR__ . '/../../includes/admin_nav.php'; ?>

<div class="container py-3">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0">Adjustment Categories</h5>
    <?php if ($can_edit): ?>
      <button class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#cat_new">Add Category</button>
    <?php endif; ?>
  </div>

  <?php if ($ok): ?><div class="alert alert-success py-2"><?php echo e($ok); ?></div><?php endif; ?>
  <?php if ($err): ?><div class="alert alert-danger py-2"><?php echo e($err); ?></div><?php endif; ?>

  <div class="card">
    <div class="card-body">
      <div class="table-responsive">
        <table class="table table-striped align-middle">
          <thead class="table-danger">
            <tr>
              <th style="width:70px;">ID</th>
              <th>Name</th>
              <th>Type</th>
              <th>Active</th>
              <th>Created</th>
              <th class="text-end" style="width:120px;">Action</th>
            </tr>
          </thead>
          <tbody>
            <?php if (!$list): ?>
              <tr><td colspan="6" class="text-center text-muted">No categories</td></tr>
            <?php else: foreach ($list as $r): ?>
              <tr>
                <td><?php echo (int)$r['id']; ?></td>
                <td><?php echo e($r['name']); ?></td>
                <td><span class="badge <?php echo $r['type']==='positive'?'text-bg-success':'text-bg-secondary'; ?>">
                  <?php echo e(ucfirst($r['type'])); ?></span>
                </td>
                <td><?php echo $r['is_active'] ? '<span class="badge text-bg-success">Yes</span>' : '<span class="badge text-bg-secondary">No</span>'; ?></td>
                <td><small class="text-muted"><?php echo e($r['created_at']); ?></small></td>
                <td class="text-end">
                  <?php if ($can_edit): ?>
                    <button class="btn btn-sm btn-outline-primary"
                            data-bs-toggle="modal"
                            data-bs-target="#cat_edit_<?php echo (int)$r['id']; ?>">Edit</button>
                  <?php else: ?>
                    <span class="text-muted">View only</span>
                  <?php endif; ?>
                </td>
              </tr>

              <?php if ($can_edit): ?>
              <!-- Edit Modal -->
              <div class="modal fade" id="cat_edit_<?php echo (int)$r['id']; ?>" tabindex="-1" aria-hidden="true">
                <div class="modal-dialog">
                  <div class="modal-content">
                        <form method="post">
                          <?php echo csrf_input(); ?>
                          <div class="modal-header">
                        <h6 class="modal-title">Edit Category</h6>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                      </div>
                      <div class="modal-body">
                        <input type="hidden" name="csrf" value="<?php echo e($csrf); ?>">
                        <input type="hidden" name="id" value="<?php echo (int)$r['id']; ?>">
                        <div class="mb-2">
                          <label class="form-label">Name</label>
                          <input class="form-control" name="name" value="<?php echo e($r['name']); ?>" required>
                        </div>
                        <div class="mb-2">
                          <label class="form-label">Type</label>
                          <select class="form-select" name="type" required>
                            <option value="positive" <?php echo $r['type']==='positive'?'selected':''; ?>>Positive</option>
                            <option value="negative" <?php echo $r['type']==='negative'?'selected':''; ?>>Negative</option>
                          </select>
                        </div>
                        <div class="form-check">
                          <input class="form-check-input" type="checkbox" name="is_active" id="act_<?php echo (int)$r['id']; ?>" <?php echo $r['is_active']?'checked':''; ?>>
                          <label class="form-check-label" for="act_<?php echo (int)$r['id']; ?>">Active</label>
                        </div>
                      </div>
                      <div class="modal-footer">
                        <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancel</button>
                        <button class="btn btn-danger">Save</button>
                      </div>
                    </form>
                  </div>
                </div>
              </div>
              <?php endif; ?>

            <?php endforeach; endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<?php if ($can_edit): ?>
<!-- New Modal -->
<div class="modal fade" id="cat_new" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <form method="post">
        <div class="modal-header">
          <h6 class="modal-title">New Category</h6>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <input type="hidden" name="csrf" value="<?php echo e($csrf); ?>">
          <div class="mb-2">
            <label class="form-label">Name</label>
            <input class="form-control" name="name" required>
          </div>
          <div class="mb-2">
            <label class="form-label">Type</label>
            <select class="form-select" name="type" required>
              <option value="positive">Positive</option>
              <option value="negative">Negative</option>
            </select>
          </div>
          <div class="form-check">
            <input class="form-check-input" type="checkbox" name="is_active" id="act_new" checked>
            <label class="form-check-label" for="act_new">Active</label>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancel</button>
          <button class="btn btn-danger">Create</button>
        </div>
      </form>
    </div>
  </div>
</div>
<?php endif; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
