<?php
// public/admin/ajax_zones_by_city.php
require_once __DIR__ . '/../../includes/admin_bootstrap.php';
header('Content-Type: application/json; charset=utf-8');
$role = get_current_role();
if (!can_view_lookups($role)) { http_response_code(403); echo json_encode(['error'=>'forbidden']); exit; }

$city_id = isset($_GET['city_id']) && ctype_digit($_GET['city_id']) ? (int)$_GET['city_id'] : 0;
if ($city_id <= 0) { echo json_encode([]); exit; }

$sql = "SELECT id, name FROM zones WHERE city_id=? AND is_active=1 ORDER BY name ASC";
$st  = $conn->prepare($sql);
$st->bind_param('i', $city_id);
$st->execute();
$rs  = $st->get_result()->fetch_all(MYSQLI_ASSOC);

echo json_encode($rs, JSON_UNESCAPED_UNICODE);
