<?php
// public/admin/approvals_store.php
require_once __DIR__ . '/../../includes/admin_bootstrap.php';
if (!can_approve_submissions(get_current_role())) { http_response_code(403); exit('Forbidden'); }

$action = $_POST['action'] ?? '';
$id = (int)($_POST['id'] ?? 0);
if ($id <= 0 || !in_array($action, ['approve','reject'], true)) { http_response_code(400); exit('Bad request'); }

$status = ($action === 'approve') ? 'approved' : 'rejected';
$stmt = $conn->prepare('UPDATE submissions SET status=? WHERE id=?');
$stmt->bind_param('si', $status, $id);
$stmt->execute();

// Optional: redirect back to the same month view
$month = $_GET['month'] ?? date('Y-m');
header('Location: pending_approvals.php?month='.$month.'&status=pending');
exit;