<?php
require_once __DIR__.'/../../includes/admin_bootstrap.php';
if (!can_manage_drivers(get_current_role())) { http_response_code(403); exit('Forbidden'); }
$csrf = get_csrf_token();

$err=''; $ok='';

function project_options_with_prefix(mysqli $conn, $selected_id = 0){
  $h=''; $q=$conn->query("SELECT id,name,prefix FROM projects ORDER BY name");
  while($r=$q->fetch_assoc()){
    $sel=((int)$r['id']===(int)$selected_id)?' selected':'';
    $h.='<option value="'.(int)$r['id'].'" data-prefix="'.e($r['prefix']).'"'.$sel.'>'.e($r['name']).' ('.e($r['prefix']).')</option>';
  }
  return $h;
}
function city_options(mysqli $conn, $selected_id = 0){
  $h=''; $q=$conn->query("SELECT id,name FROM cities ORDER BY name");
  while($r=$q->fetch_assoc()){
    $sel=((int)$r['id']===(int)$selected_id)?' selected':'';
    $h.='<option value="'.(int)$r['id'].'"'.$sel.'>'.e($r['name']).'</option>';
  }
  return $h;
}
function nationality_options(mysqli $conn, $selected_id = 0){
  $h='<option value="">Select nationality</option>';
  $q=$conn->query("SELECT id,name FROM nationalities ORDER BY name");
  while($r=$q->fetch_assoc()){
    $sel=((int)$r['id']===(int)$selected_id)?' selected':'';
    $h.='<option value="'.(int)$r['id'].'"'.$sel.'>'.e($r['name']).'</option>';
  }
  return $h;
}
function salary_scheme_options(mysqli $conn, $selected_id = 0){
  $h='<option value="">Select salary scheme</option>';
  $q=$conn->query("SELECT id,name FROM salary_schemes ORDER BY name");
  while($r=$q->fetch_assoc()){
    $sel=((int)$r['id']===(int)$selected_id)?' selected':'';
    $h.='<option value="'.(int)$r['id'].'"'.$sel.'>'.e($r['name']).'</option>';
  }
  return $h;
}
function type_options(mysqli $conn, $selected_id = 0){
  $h='<option value="">Select type</option>';
  $q=$conn->query("SELECT id,name FROM types WHERE is_active=1 ORDER BY name");
  while($r=$q->fetch_assoc()){
    $sel=((int)$r['id']===(int)$selected_id)?' selected':'';
    $h.='<option value="'.(int)$r['id'].'"'.$sel.'>'.e($r['name']).'</option>';
  }
  return $h;
}

if ($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['csrf']) && hash_equals($csrf, $_POST['csrf'])) {
  $first = trim($_POST['first_name'] ?? '');
  $last  = trim($_POST['last_name'] ?? '');
  $project_id = (int)($_POST['project_id'] ?? 0);
  $city_id    = (int)($_POST['city_id'] ?? 0);
  $zone_id    = (int)($_POST['zone_id'] ?? 0);
  $nationality_id   = (int)($_POST['nationality_id'] ?? 0);
  $type_id          = (int)($_POST['type_id'] ?? 0);
  $salary_scheme_id = (int)($_POST['salary_scheme_id'] ?? 0);
  $id_digits  = trim($_POST['uuid_digits'] ?? ''); // civil ID or any length digits, no padding
  $plain      = trim($_POST['password'] ?? '');
  $work_phone     = trim($_POST['work_phone'] ?? '');
  $personal_phone = trim($_POST['personal_phone'] ?? '');
  $ref_note       = trim($_POST['ref_note'] ?? '');
  $partner_uuid   = trim($_POST['partner_uuid'] ?? '');

  // Fetch project prefix
  $pref_stmt = $conn->prepare('SELECT prefix FROM projects WHERE id=?');
  $pref_stmt->bind_param('i', $project_id);
  $pref_stmt->execute();
  $pref_row = $pref_stmt->get_result()->fetch_assoc();
  $prefix = $pref_row['prefix'] ?? '';

  // Validate
  if ($first==='' || $project_id<=0 || $city_id<=0) {
    $err='First name, project and city are required.';
  } elseif ($prefix==='') {
    $err='Selected project has no prefix.';
  } elseif (!preg_match('/^[0-9]+$/', $id_digits)) {
    $err='Driver ID digits must be numbers only.';
  } elseif ($plain==='' || strlen($plain)<6) {
    $err='Password must be at least 6 characters.';
  } elseif ($work_phone!=='' && !preg_match('/^\+?[0-9]{6,20}$/', $work_phone)) {
    $err='Invalid work phone.';
  } elseif ($personal_phone!=='' && !preg_match('/^\+?[0-9]{6,20}$/', $personal_phone)) {
    $err='Invalid personal phone.';
  } else {
    $partner_id = $prefix . $id_digits; // no zero padding
    // Uniqueness
    $chk = $conn->prepare('SELECT id FROM drivers WHERE partner_id=?');
    $chk->bind_param('s', $partner_id);
    $chk->execute();
    if ($chk->get_result()->num_rows > 0) {
      $err='This Driver ID already exists: ' . e($partner_id);
    } else {
      if ($partner_uuid!=='') {
        $c2=$conn->prepare('SELECT id FROM drivers WHERE partner_uuid=?');
        $c2->bind_param('s', $partner_uuid);
        $c2->execute();
        if ($c2->get_result()->num_rows>0) $err='Partner UUID already exists.';
      }
      if ($err==='') {
        $hash = password_hash($plain, PASSWORD_BCRYPT);
        // NULL-ables
        $zone_id          = $zone_id ?: null;
        $nationality_id   = $nationality_id ?: null;
        $type_id          = $type_id ?: null;
        $salary_scheme_id = $salary_scheme_id ?: null;

        $stmt = $conn->prepare('
          INSERT INTO drivers(
            partner_id, first_name, last_name, project_id, city_id, zone_id,
            nationality_id, type_id, salary_scheme_id,
            login_password, status, work_phone, personal_phone, ref_note, partner_uuid
          ) VALUES (?,?,?,?,?,?,?,?,?,?,"active",?,?,?,?)
        ');
        // 14 bind variables total (3 strings, 6 integers, 5 strings)
        // s s s i i i i i i s s s s s
        $stmt->bind_param(
          'sssiiiiiisssss',
          $partner_id,      // s - string
          $first,           // s - string
          $last,            // s - string
          $project_id,      // i - integer
          $city_id,         // i - integer
          $zone_id,         // i - integer (nullable)
          $nationality_id,  // i - integer (nullable)
          $type_id,         // i - integer (nullable)
          $salary_scheme_id,// i - integer (nullable)
          $hash,            // s - string
          $work_phone,      // s - string
          $personal_phone,  // s - string
          $ref_note,        // s - string
          $partner_uuid     // s - string
        );
        if ($stmt->execute()) {
          $ok='Driver created with ID ' . e($partner_id);
          $_POST = [];
        } else {
          $err='Insert failed.';
        }
      }
    }
  }
}

// Sticky
$sticky = [
  'first_name'  => e($_POST['first_name'] ?? ''),
  'last_name'   => e($_POST['last_name'] ?? ''),
  'project_id'  => (int)($_POST['project_id'] ?? 0),
  'city_id'     => (int)($_POST['city_id'] ?? 0),
  'zone_id'     => (int)($_POST['zone_id'] ?? 0),
  'uuid_digits' => e($_POST['uuid_digits'] ?? ''),
  'password'    => '',
  'nationality_id'   => (int)($_POST['nationality_id'] ?? 0),
  'type_id'          => (int)($_POST['type_id'] ?? 0),
  'salary_scheme_id' => (int)($_POST['salary_scheme_id'] ?? 0),
  'work_phone'       => e($_POST['work_phone'] ?? ''),
  'personal_phone'   => e($_POST['personal_phone'] ?? ''),
  'ref_note'         => e($_POST['ref_note'] ?? ''),
  'partner_uuid'     => e($_POST['partner_uuid'] ?? ''),
];
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title>Create Driver - Hisbuu</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
  <style>
    .section-title {
      font-size: 14px;
      font-weight: 600;
      color: #64748b;
      text-transform: uppercase;
      letter-spacing: 0.5px;
      margin-bottom: 16px;
      padding-bottom: 8px;
      border-bottom: 2px solid #e2e8f0;
    }
    .preview-card {
      background: linear-gradient(135deg, #dc3545 0%, #b02a37 100%);
      color: #fff;
      border-radius: 12px;
      padding: 16px 20px;
      margin-bottom: 0;
    }
    .preview-card strong {
      font-size: 12px;
      opacity: 0.85;
      text-transform: uppercase;
      letter-spacing: 0.5px;
    }
    .preview-card #preview_full {
      font-size: 24px;
      font-weight: 700;
      display: block;
      margin-top: 4px;
      letter-spacing: 1px;
    }
    .form-control:focus, .form-select:focus {
      border-color: #dc3545;
      box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.15);
    }
    .input-group-text {
      background: #f8fafc;
      border-color: #e2e8f0;
      font-weight: 600;
      color: #dc3545;
    }
  </style>
</head>
<body class="bg-light">
<?php include __DIR__ . '/../../includes/admin_nav.php'; ?>

<div class="container py-4" style="max-width:980px">
  <div class="d-flex justify-content-between align-items-center mb-4">
    <div>
      <h4 class="mb-1"><i class="bi bi-person-plus-fill text-danger"></i> Create Driver</h4>
      <p class="text-muted mb-0 small">Add a new driver to the system</p>
    </div>
    <a href="driver_list.php" class="btn btn-outline-secondary btn-sm">
      <i class="bi bi-arrow-left"></i> Back to list
    </a>
  </div>

  <?php if($err): ?>
    <div class="alert alert-danger d-flex align-items-center">
      <i class="bi bi-exclamation-triangle-fill me-2"></i>
      <div><?php echo $err; ?></div>
    </div>
  <?php endif; ?>

  <?php if($ok): ?>
    <div class="alert alert-success d-flex align-items-center">
      <i class="bi bi-check-circle-fill me-2"></i>
      <div><?php echo $ok; ?></div>
    </div>
  <?php endif; ?>

  <div class="card shadow-sm">
    <div class="card-body p-4">
      <form method="POST" class="row g-3">
        <input type="hidden" name="csrf" value="<?php echo e($csrf); ?>">

        <!-- Personal Information -->
        <div class="col-12">
          <div class="section-title"><i class="bi bi-person"></i> Personal Information</div>
        </div>

        <div class="col-md-6">
          <label class="form-label">First name <span class="text-danger">*</span></label>
          <input class="form-control" name="first_name" value="<?php echo $sticky['first_name']; ?>" required>
        </div>
        <div class="col-md-6">
          <label class="form-label">Last name</label>
          <input class="form-control" name="last_name" value="<?php echo $sticky['last_name']; ?>">
        </div>

        <div class="col-md-6">
          <label class="form-label">Nationality</label>
          <select class="form-select" name="nationality_id">
            <?php echo nationality_options($conn, $sticky['nationality_id']); ?>
          </select>
        </div>

        <div class="col-md-6">
          <label class="form-label">Type</label>
          <select class="form-select" name="type_id">
            <?php echo type_options($conn, $sticky['type_id']); ?>
          </select>
        </div>

        <!-- Assignment Details -->
        <div class="col-12 mt-4">
          <div class="section-title"><i class="bi bi-geo-alt"></i> Assignment Details</div>
        </div>

        <div class="col-md-6">
          <label class="form-label">Project <span class="text-danger">*</span></label>
          <select class="form-select" name="project_id" id="project_id" required>
            <option value="">Select project</option>
            <?php echo project_options_with_prefix($conn, $sticky['project_id']); ?>
          </select>
        </div>

        <div class="col-md-6">
          <label class="form-label">Salary Scheme</label>
          <select class="form-select" name="salary_scheme_id">
            <?php echo salary_scheme_options($conn, $sticky['salary_scheme_id']); ?>
          </select>
        </div>

        <div class="col-md-6">
          <label class="form-label">City <span class="text-danger">*</span></label>
          <select class="form-select" name="city_id" id="city_id" required>
            <option value="">Select city</option>
            <?php echo city_options($conn, $sticky['city_id']); ?>
          </select>
        </div>

        <div class="col-md-6">
          <label class="form-label">Zone</label>
          <select class="form-select" name="zone_id" id="zone_id">
            <option value="">Select city first</option>
          </select>
        </div>

        <!-- Login Credentials -->
        <div class="col-12 mt-4">
          <div class="section-title"><i class="bi bi-key"></i> Login Credentials</div>
        </div>

        <div class="col-md-6">
          <label class="form-label">Driver ID digits <span class="text-danger">*</span></label>
          <div class="input-group">
            <span class="input-group-text" id="prefix_hint">PR</span>
            <input class="form-control" name="uuid_digits" id="uuid_digits" inputmode="numeric" pattern="[0-9]+" placeholder="Enter digits only" value="<?php echo $sticky['uuid_digits']; ?>" required>
          </div>
          <div class="form-text">Full ID will be PREFIX + digits (no padding)</div>
        </div>

        <div class="col-md-6">
          <label class="form-label">Password <span class="text-danger">*</span></label>
          <input type="password" name="password" class="form-control" minlength="6" placeholder="Minimum 6 characters" required>
          <div class="form-text">Driver will use this to log in</div>
        </div>

        <!-- Contact Information -->
        <div class="col-12 mt-4">
          <div class="section-title"><i class="bi bi-telephone"></i> Contact Information</div>
        </div>

        <div class="col-md-6">
          <label class="form-label">Work phone</label>
          <input class="form-control" name="work_phone" value="<?php echo $sticky['work_phone']; ?>" pattern="\+?[0-9]{6,20}" placeholder="+965xxxxxxxx">
        </div>
        <div class="col-md-6">
          <label class="form-label">Personal phone</label>
          <input class="form-control" name="personal_phone" value="<?php echo $sticky['personal_phone']; ?>" pattern="\+?[0-9]{6,20}" placeholder="+965xxxxxxxx">
        </div>

        <!-- Additional Information -->
        <div class="col-12 mt-4">
          <div class="section-title"><i class="bi bi-info-circle"></i> Additional Information</div>
        </div>

        <div class="col-md-6">
          <label class="form-label">Partner UUID <small class="text-muted">(optional)</small></label>
          <input class="form-control" name="partner_uuid" value="<?php echo $sticky['partner_uuid']; ?>" maxlength="64" placeholder="External system ID">
        </div>

        <div class="col-md-6">
          <label class="form-label">Reference note</label>
          <input class="form-control" name="ref_note" maxlength="255" value="<?php echo $sticky['ref_note']; ?>" placeholder="Any additional notes">
        </div>

        <!-- Preview -->
        <div class="col-12 mt-4">
          <div class="preview-card">
            <strong>Driver ID Preview</strong>
            <span id="preview_full">PR</span>
          </div>
        </div>

        <div class="col-12 d-flex justify-content-between align-items-center mt-4 pt-3 border-top">
          <small class="text-muted"><span class="text-danger">*</span> Required fields</small>
          <button type="submit" class="btn btn-danger px-4">
            <i class="bi bi-plus-circle"></i> Create Driver
          </button>
        </div>
      </form>
    </div>
  </div>
</div>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script>
(function() {
  const sel = document.getElementById('project_id');
  const hint = document.getElementById('prefix_hint');
  const digits = document.getElementById('uuid_digits');
  const preview = document.getElementById('preview_full');

  function getPrefix(){
    const opt = sel.options[sel.selectedIndex];
    return opt ? (opt.getAttribute('data-prefix') || '') : '';
  }
  function render(){
    const pref = getPrefix() || 'PR';
    hint.textContent = pref;
    preview.textContent = pref + (digits.value || '');
  }
  sel.addEventListener('change', render);
  digits.addEventListener('input', function(){
    this.value = this.value.replace(/[^0-9]/g,'');
    render();
  });
  render();

  // Load zones for selected city
  function loadZones(cityId) {
    var $zone = $('#zone_id');
    $zone.html('<option>Loading…</option>');
    $.get('zones_by_city.php', { city_id: cityId })
      .done(function (html) { $zone.html(html); })
      .fail(function (xhr) {
        console.error('Failed to load zones:', xhr);
        $zone.html('<option value="">Select zone</option>');
      });
  }
  $('#city_id').on('change', function () {
    var cid = $(this).val() || '';
    if (cid) loadZones(cid); else $('#zone_id').html('<option value="">Select zone</option>');
  });
  var initCity = $('#city_id').val();
  if (initCity) loadZones(initCity);
})();
</script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
