<?php
require_once __DIR__.'/../../includes/admin_bootstrap.php';
if (!can_manage_drivers(get_current_role())) { http_response_code(403); exit('Forbidden'); }
$csrf = get_csrf_token();

$err = ''; $ok = '';
$driver_id = isset($_GET['id']) && ctype_digit($_GET['id']) ? (int)$_GET['id'] : 0;
if ($driver_id <= 0) { http_response_code(400); exit('Invalid driver id'); }

function project_options_with_prefix(mysqli $conn, $selected_id = 0){
  $h=''; $q=$conn->query("SELECT id,name,prefix FROM projects ORDER BY name");
  while($r=$q->fetch_assoc()){
    $sel=((int)$r['id']===(int)$selected_id)?' selected':'';
    $h.='<option value="'.(int)$r['id'].'" data-prefix="'.e($r['prefix']).'"'.$sel.'>'.e($r['name']).' ('.e($r['prefix']).')</option>';
  }
  return $h;
}
function city_options(mysqli $conn, $selected_id = 0){
  $h=''; $q=$conn->query("SELECT id,name FROM cities ORDER BY name");
  while($r=$q->fetch_assoc()){
    $sel=((int)$r['id']===(int)$selected_id)?' selected':'';
    $h.='<option value="'.(int)$r['id'].'"'.$sel.'>'.e($r['name']).'</option>';
  }
  return $h;
}
function zone_options_for_city(mysqli $conn, int $city_id, int $selected_id = 0){
  if ($city_id <= 0) return '<option value="">Select zone</option>';
  $st=$conn->prepare("SELECT id,name FROM zones WHERE city_id=? ORDER BY name");
  $st->bind_param('i', $city_id);
  $st->execute();
  $q=$st->get_result();
  $h='<option value="">Select zone</option>';
  while($r=$q->fetch_assoc()){
    $sel=((int)$r['id'] === $selected_id)?' selected':'';
    $h.='<option value="'.(int)$r['id'].'"'.$sel.'>'.e($r['name']).'</option>';
  }
  return $h;
}
function nationality_options(mysqli $conn, $selected_id = 0){
  $h='<option value="">Select nationality</option>';
  $q=$conn->query("SELECT id,name FROM nationalities ORDER BY name");
  while($r=$q->fetch_assoc()){
    $sel=((int)$r['id']===(int)$selected_id)?' selected':'';
    $h.='<option value="'.(int)$r['id'].'"'.$sel.'>'.e($r['name']).'</option>';
  }
  return $h;
}
function salary_scheme_options(mysqli $conn, $selected_id = 0){
  $h='<option value="">Select salary scheme</option>';
  $q=$conn->query("SELECT id,name FROM salary_schemes ORDER BY name");
  while($r=$q->fetch_assoc()){
    $sel=((int)$r['id']===(int)$selected_id)?' selected':'';
    $h.='<option value="'.(int)$r['id'].'"'.$sel.'>'.e($r['name']).'</option>';
  }
  return $h;
}
function type_options(mysqli $conn, $selected_id = 0){
  $h='<option value="">Select type</option>';
  $q=$conn->query("SELECT id,name FROM types WHERE is_active=1 ORDER BY name");
  while($r=$q->fetch_assoc()){
    $sel=((int)$r['id']===(int)$selected_id)?' selected':'';
    $h.='<option value="'.(int)$r['id'].'"'.$sel.'>'.e($r['name']).'</option>';
  }
  return $h;
}

// Load driver
$stmt = $conn->prepare("
  SELECT id, partner_id, first_name, last_name, project_id, city_id,
         zone_id, nationality_id, type_id, salary_scheme_id,
         work_phone, personal_phone, ref_note, partner_uuid, status
  FROM drivers
  WHERE id=? LIMIT 1
");
$stmt->bind_param('i', $driver_id);
$stmt->execute();
$row = $stmt->get_result()->fetch_assoc();
if (!$row) { http_response_code(404); exit('Driver not found'); }

// Save
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['csrf']) && hash_equals($csrf, $_POST['csrf'])) {
  $first = trim($_POST['first_name'] ?? '');
  $last  = trim($_POST['last_name'] ?? '');
  $project_id = (int)($_POST['project_id'] ?? 0);
  $city_id    = (int)($_POST['city_id'] ?? 0);
  $zone_id    = (int)($_POST['zone_id'] ?? 0);
  $nationality_id   = (int)($_POST['nationality_id'] ?? 0);
  $type_id          = (int)($_POST['type_id'] ?? 0);
  $salary_scheme_id = (int)($_POST['salary_scheme_id'] ?? 0);
  $work_phone     = trim($_POST['work_phone'] ?? '');
  $personal_phone = trim($_POST['personal_phone'] ?? '');
  $ref_note       = trim($_POST['ref_note'] ?? '');
  $partner_uuid   = trim($_POST['partner_uuid'] ?? '');

  if ($first==='' || $project_id<=0 || $city_id<=0) {
    $err = 'First name, project, and city are required.';
  } elseif ($work_phone!=='' && !preg_match('/^\+?[0-9]{6,20}$/', $work_phone)) {
    $err='Invalid work phone.';
  } elseif ($personal_phone!=='' && !preg_match('/^\+?[0-9]{6,20}$/', $personal_phone)) {
    $err='Invalid personal phone.';
  } else {
    if ($partner_uuid !== '') {
      $chk = $conn->prepare("SELECT id FROM drivers WHERE partner_uuid=? AND id<>?");
      $chk->bind_param('si', $partner_uuid, $driver_id);
      $chk->execute();
      if ($chk->get_result()->num_rows > 0) {
        $err = 'Partner UUID already used by another driver.';
      }
    }
    if ($err==='') {
      // Allow NULLs for optionals
      $zone_id          = $zone_id ?: null;
      $nationality_id   = $nationality_id ?: null;
      $type_id          = $type_id ?: null;
      $salary_scheme_id = $salary_scheme_id ?: null;

      $st = $conn->prepare("
        UPDATE drivers
           SET first_name=?,
               last_name=?,
               project_id=?,
               city_id=?,
               zone_id=?,
               nationality_id=?,
               type_id=?,
               salary_scheme_id=?,
               work_phone=?,
               personal_phone=?,
               ref_note=?,
               partner_uuid=?
         WHERE id=? LIMIT 1
      ");
      $st->bind_param(
        'ssiiiiiissssi',
        $first, $last,
        $project_id, $city_id, $zone_id, $nationality_id, $type_id, $salary_scheme_id,
        $work_phone, $personal_phone, $ref_note, $partner_uuid,
        $driver_id
      );

      if ($st->execute()) {
        $ok = 'Driver updated successfully.';

        // Optional password reset for privileged roles
        $role = strtolower(current_user_role() ?? '');
        $can_reset_pw = in_array($role, ['super administrator','administrator','finance administrator'], true);
        $np1 = trim($_POST['new_password'] ?? '');
        $np2 = trim($_POST['new_password2'] ?? '');
        if ($can_reset_pw && ($np1!=='' || $np2!=='')) {
          if ($np1==='' || strlen($np1)<6) {
            $err = 'New password must be at least 6 characters.';
          } elseif ($np1 !== $np2) {
            $err = 'New password and confirmation do not match.';
          } else {
            $hash = password_hash($np1, PASSWORD_BCRYPT);
            $pw = $conn->prepare('UPDATE drivers SET login_password=? WHERE id=? LIMIT 1');
            $pw->bind_param('si', $hash, $driver_id);
            if ($pw->execute()) $ok .= ' Password updated.';
            else $err = 'Failed to update password.';
          }
        }

        // Reload
        $stmt = $conn->prepare("
          SELECT id, partner_id, first_name, last_name, project_id, city_id,
                 zone_id, nationality_id, type_id, salary_scheme_id,
                 work_phone, personal_phone, ref_note, partner_uuid, status
          FROM drivers WHERE id=? LIMIT 1
        ");
        $stmt->bind_param('i', $driver_id);
        $stmt->execute();
        $row = $stmt->get_result()->fetch_assoc();
      } else {
        $err = 'Update failed.';
      }
    }
  }
}

$first_name       = e($row['first_name'] ?? '');
$last_name        = e($row['last_name'] ?? '');
$partner_id       = e($row['partner_id'] ?? '');
$driver_status    = e($row['status'] ?? 'active');
$project_id_sel   = (int)($row['project_id'] ?? 0);
$city_id_sel      = (int)($row['city_id'] ?? 0);
$zone_id_sel      = (int)($row['zone_id'] ?? 0);
$nationality_sel  = (int)($row['nationality_id'] ?? 0);
$type_sel         = (int)($row['type_id'] ?? 0);
$scheme_sel       = (int)($row['salary_scheme_id'] ?? 0);
$work_phone       = e($row['work_phone'] ?? '');
$personal_phone   = e($row['personal_phone'] ?? '');
$ref_note         = e($row['ref_note'] ?? '');
$partner_uuid     = e($row['partner_uuid'] ?? '');

$PAGE_TITLE = 'Edit Driver: ' . trim($row['first_name'] . ' ' . $row['last_name']);
require_once __DIR__ . '/../../includes/admin_header.php';
?>

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

<style>
.section-header {
  border-left: 4px solid #dc3545;
  padding-left: 1rem;
  margin-bottom: 1.5rem;
}
.form-section {
  background: #f8f9fa;
  border-radius: 0.5rem;
  padding: 1.5rem;
  margin-bottom: 1.5rem;
}
.driver-header-card {
  background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
  color: white;
}
.required-field::after {
  content: ' *';
  color: #dc3545;
}
.save-section {
  position: sticky;
  bottom: 0;
  background: white;
  padding: 1rem 0;
  border-top: 2px solid #dee2e6;
  z-index: 100;
  box-shadow: 0 -4px 12px rgba(0,0,0,0.1);
}
</style>

<div class="d-flex justify-content-between align-items-start mb-4">
  <div>
    <h4 class="mb-1">Edit Driver</h4>
    <p class="text-muted small mb-0">Update driver information and settings</p>
  </div>
  <div class="d-flex gap-2">
    <a href="<?= base_url('admin/driver_view.php?id='.$driver_id) ?>" class="btn btn-outline-secondary btn-sm">
      <i class="bi bi-eye me-1"></i> View Profile
    </a>
    <a href="<?= base_url('admin/driver_list.php') ?>" class="btn btn-outline-secondary btn-sm">
      <i class="bi bi-arrow-left me-1"></i> Back to List
    </a>
  </div>
</div>

<!-- Driver Header -->
<div class="card driver-header-card shadow-sm mb-4">
  <div class="card-body">
    <div class="row align-items-center">
      <div class="col-auto">
        <div style="width: 60px; height: 60px; border-radius: 50%; background: rgba(255,255,255,0.2); display: flex; align-items: center; justify-content: center; font-size: 1.5rem; font-weight: 600;">
          <?= strtoupper(substr($row['first_name'] ?? 'D', 0, 1)) ?>
        </div>
      </div>
      <div class="col">
        <h5 class="mb-1"><?= $first_name ?> <?= $last_name ?></h5>
        <div class="d-flex gap-3 small">
          <span><i class="bi bi-person-badge me-1"></i>ID: <?= $partner_id ?></span>
          <span id="status-display">
            <i class="bi bi-circle-fill me-1"></i>Status:
            <span class="badge <?= $driver_status === 'active' ? 'bg-success' : 'bg-secondary' ?>">
              <?= ucfirst($driver_status) ?>
            </span>
          </span>
        </div>
      </div>
      <div class="col-auto">
        <button type="button" id="toggleStatusBtn" class="btn btn-sm <?= $driver_status === 'active' ? 'btn-warning' : 'btn-success' ?>" data-driver-id="<?= $driver_id ?>" data-current-status="<?= $driver_status ?>">
          <i class="bi bi-<?= $driver_status === 'active' ? 'pause-circle' : 'play-circle' ?> me-1"></i>
          <?= $driver_status === 'active' ? 'Deactivate' : 'Activate' ?>
        </button>
      </div>
    </div>
  </div>
</div>

<?php if($err): ?>
<div class="alert alert-danger alert-dismissible fade show shadow-sm">
  <i class="bi bi-exclamation-triangle-fill me-2"></i>
  <?= $err ?>
  <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<?php if($ok): ?>
<div class="alert alert-success alert-dismissible fade show shadow-sm">
  <i class="bi bi-check-circle-fill me-2"></i>
  <?= $ok ?>
  <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<form method="post" id="driverEditForm">
  <input type="hidden" name="csrf" value="<?= e($csrf) ?>">

  <!-- Basic Information -->
  <div class="card shadow-sm mb-4">
    <div class="card-header bg-white">
      <h6 class="mb-0"><i class="bi bi-person-circle me-2"></i>Basic Information</h6>
    </div>
    <div class="card-body">
      <div class="row g-3">
        <div class="col-md-6">
          <label class="form-label required-field">Driver ID</label>
          <input class="form-control" value="<?= $partner_id ?>" disabled>
          <div class="form-text">This ID is auto-generated and cannot be changed</div>
        </div>
        <div class="col-md-6">
          <label class="form-label">Partner UUID</label>
          <input class="form-control" name="partner_uuid" value="<?= $partner_uuid ?>" maxlength="64" placeholder="Optional external reference ID">
        </div>

        <div class="col-md-6">
          <label class="form-label required-field">First Name</label>
          <input class="form-control" name="first_name" value="<?= $first_name ?>" required>
        </div>
        <div class="col-md-6">
          <label class="form-label">Last Name</label>
          <input class="form-control" name="last_name" value="<?= $last_name ?>">
        </div>
      </div>
    </div>
  </div>

  <!-- Work Assignment -->
  <div class="card shadow-sm mb-4">
    <div class="card-header bg-white">
      <h6 class="mb-0"><i class="bi bi-building me-2"></i>Work Assignment</h6>
    </div>
    <div class="card-body">
      <div class="row g-3">
        <div class="col-md-6">
          <label class="form-label required-field">Project</label>
          <select class="form-select" name="project_id" required>
            <option value="">Select Project</option>
            <?= project_options_with_prefix($conn, $project_id_sel) ?>
          </select>
        </div>
        <div class="col-md-6">
          <label class="form-label required-field">City</label>
          <select class="form-select" name="city_id" id="city_id" required>
            <option value="">Select City</option>
            <?= city_options($conn, $city_id_sel) ?>
          </select>
        </div>

        <div class="col-md-6">
          <label class="form-label">Zone</label>
          <select class="form-select" name="zone_id" id="zone_id">
            <?= zone_options_for_city($conn, $city_id_sel, $zone_id_sel) ?>
          </select>
          <div class="form-text">Zone will update based on selected city</div>
        </div>
        <div class="col-md-6">
          <label class="form-label">Nationality</label>
          <select class="form-select" name="nationality_id">
            <?= nationality_options($conn, $nationality_sel) ?>
          </select>
        </div>
      </div>
    </div>
  </div>

  <!-- Employment Details -->
  <div class="card shadow-sm mb-4">
    <div class="card-header bg-white">
      <h6 class="mb-0"><i class="bi bi-briefcase me-2"></i>Employment Details</h6>
    </div>
    <div class="card-body">
      <div class="row g-3">
        <div class="col-md-6">
          <label class="form-label">Driver Type</label>
          <select class="form-select" name="type_id">
            <?= type_options($conn, $type_sel) ?>
          </select>
        </div>
        <div class="col-md-6">
          <label class="form-label">Salary Scheme</label>
          <select class="form-select" name="salary_scheme_id">
            <?= salary_scheme_options($conn, $scheme_sel) ?>
          </select>
        </div>
      </div>
    </div>
  </div>

  <!-- Contact Information -->
  <div class="card shadow-sm mb-4">
    <div class="card-header bg-white">
      <h6 class="mb-0"><i class="bi bi-telephone me-2"></i>Contact Information</h6>
    </div>
    <div class="card-body">
      <div class="row g-3">
        <div class="col-md-6">
          <label class="form-label">Work Phone</label>
          <div class="input-group">
            <span class="input-group-text"><i class="bi bi-telephone"></i></span>
            <input class="form-control" name="work_phone" value="<?= $work_phone ?>" pattern="\+?[0-9]{6,20}" placeholder="+965XXXXXXXX">
          </div>
          <div class="form-text">Format: +965XXXXXXXX or XXXXXXXX</div>
        </div>
        <div class="col-md-6">
          <label class="form-label">Personal Phone</label>
          <div class="input-group">
            <span class="input-group-text"><i class="bi bi-phone"></i></span>
            <input class="form-control" name="personal_phone" value="<?= $personal_phone ?>" pattern="\+?[0-9]{6,20}" placeholder="+965XXXXXXXX">
          </div>
          <div class="form-text">Format: +965XXXXXXXX or XXXXXXXX</div>
        </div>

        <div class="col-12">
          <label class="form-label">Reference Note</label>
          <textarea class="form-control" name="ref_note" maxlength="255" rows="2" placeholder="Any additional notes or references..."><?= $ref_note ?></textarea>
          <div class="form-text">Maximum 255 characters</div>
        </div>
      </div>
    </div>
  </div>

  <!-- Password Reset (Privileged Users Only) -->
  <?php
  $role = strtolower(current_user_role() ?? '');
  $can_reset_pw = in_array($role, ['super administrator','administrator','finance administrator'], true);
  if ($can_reset_pw):
  ?>
  <div class="card shadow-sm mb-4 border-warning">
    <div class="card-header bg-warning bg-opacity-10">
      <h6 class="mb-0"><i class="bi bi-shield-lock me-2"></i>Reset Driver Password</h6>
    </div>
    <div class="card-body">
      <div class="alert alert-warning mb-3">
        <i class="bi bi-exclamation-triangle me-2"></i>
        <strong>Caution:</strong> Only reset password if specifically requested by the driver or for security purposes.
      </div>
      <div class="row g-3">
        <div class="col-md-6">
          <label class="form-label">New Password</label>
          <div class="input-group">
            <span class="input-group-text"><i class="bi bi-key"></i></span>
            <input type="password" name="new_password" class="form-control" minlength="6" placeholder="Leave blank to keep current">
          </div>
        </div>
        <div class="col-md-6">
          <label class="form-label">Confirm New Password</label>
          <div class="input-group">
            <span class="input-group-text"><i class="bi bi-key-fill"></i></span>
            <input type="password" name="new_password2" class="form-control" minlength="6" placeholder="Confirm new password">
          </div>
        </div>
        <div class="col-12">
          <div class="form-text">
            <i class="bi bi-info-circle me-1"></i>
            Minimum 6 characters. Leave both fields blank to keep the current password.
          </div>
        </div>
      </div>
    </div>
  </div>
  <?php endif; ?>

  <!-- Save Button (Sticky) -->
  <div class="save-section">
    <div class="d-flex justify-content-between align-items-center">
      <div class="text-muted small">
        <i class="bi bi-info-circle me-1"></i>
        Fields marked with <span class="text-danger">*</span> are required
      </div>
      <div class="d-flex gap-2">
        <a href="<?= base_url('admin/driver_view.php?id='.$driver_id) ?>" class="btn btn-outline-secondary">
          <i class="bi bi-x-circle me-1"></i> Cancel
        </a>
        <button type="submit" class="btn btn-primary">
          <i class="bi bi-check-circle me-1"></i> Save Changes
        </button>
      </div>
    </div>
  </div>
</form>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script>
$(function () {
  const currentZone = '<?= isset($zone_id_sel) ? (int)$zone_id_sel : 0 ?>';

  function loadZones(cityId, selectedId) {
    var $zone = $('#zone_id');
    $zone.html('<option>Loading zones...</option>').prop('disabled', true);
    $.get('<?= base_url('admin/zones_by_city.php') ?>', { city_id: cityId })
      .done(function (html) {
        $zone.html(html).prop('disabled', false);
        if (selectedId) $zone.val(String(selectedId));
      })
      .fail(function () {
        $zone.html('<option value="">Select zone</option>').prop('disabled', false);
      });
  }

  $('#city_id').on('change', function () {
    var cid = $(this).val() || '';
    if (cid) {
      loadZones(cid, null);
    } else {
      $('#zone_id').html('<option value="">Select zone</option>').prop('disabled', false);
    }
  });

  // Load zones on page load if city is already selected
  var initCity = $('#city_id').val();
  if (initCity) {
    loadZones(initCity, currentZone);
  }

  // Form validation
  $('#driverEditForm').on('submit', function(e) {
    const pw1 = $('input[name="new_password"]').val();
    const pw2 = $('input[name="new_password2"]').val();

    if (pw1 || pw2) {
      if (pw1 !== pw2) {
        e.preventDefault();
        alert('Password and confirmation do not match!');
        return false;
      }
      if (pw1.length < 6) {
        e.preventDefault();
        alert('Password must be at least 6 characters!');
        return false;
      }
    }
  });

  // Toggle driver status
  $('#toggleStatusBtn').on('click', function() {
    const $btn = $(this);
    const driverId = $btn.data('driver-id');
    const currentStatus = $btn.data('current-status');
    const newStatus = currentStatus === 'active' ? 'inactive' : 'active';
    const actionText = newStatus === 'active' ? 'activate' : 'deactivate';

    // Confirmation dialog
    const confirmMsg = newStatus === 'active'
      ? 'Are you sure you want to ACTIVATE this driver?\n\nThe driver will be able to log in and submit data.'
      : 'Are you sure you want to DEACTIVATE this driver?\n\nThe driver will be logged out and unable to access the system.';

    if (!confirm(confirmMsg)) {
      return;
    }

    // Disable button during request
    $btn.prop('disabled', true).html('<i class="bi bi-hourglass-split"></i> Processing...');

    $.ajax({
      url: '<?= base_url('admin/driver_toggle_status.php') ?>',
      method: 'POST',
      data: {
        driver_id: driverId,
        new_status: newStatus,
        csrf: '<?= $csrf ?>'
      },
      dataType: 'json',
      success: function(response) {
        if (response.success) {
          // Update button state
          $btn.data('current-status', newStatus);

          if (newStatus === 'active') {
            $btn.removeClass('btn-success').addClass('btn-warning');
            $btn.html('<i class="bi bi-pause-circle me-1"></i> Deactivate');
          } else {
            $btn.removeClass('btn-warning').addClass('btn-success');
            $btn.html('<i class="bi bi-play-circle me-1"></i> Activate');
          }

          // Update status display
          const badgeClass = newStatus === 'active' ? 'bg-success' : 'bg-secondary';
          $('#status-display').html(
            '<i class="bi bi-circle-fill me-1"></i>Status: ' +
            '<span class="badge ' + badgeClass + '">' +
            (newStatus.charAt(0).toUpperCase() + newStatus.slice(1)) +
            '</span>'
          );

          // Show success message
          const successMsg = $('<div class="alert alert-success alert-dismissible fade show shadow-sm mt-3">' +
            '<i class="bi bi-check-circle-fill me-2"></i>' +
            'Driver has been successfully ' + (newStatus === 'active' ? 'activated' : 'deactivated') + '.' +
            '<button type="button" class="btn-close" data-bs-dismiss="alert"></button>' +
            '</div>');
          $('.driver-header-card').after(successMsg);

          // Auto-dismiss after 5 seconds
          setTimeout(function() {
            successMsg.alert('close');
          }, 5000);
        } else {
          alert('Error: ' + (response.error || 'Failed to update driver status'));
          $btn.prop('disabled', false);
        }
      },
      error: function(xhr) {
        alert('An error occurred while updating the driver status. Please try again.');
        $btn.prop('disabled', false);

        // Restore button text based on current status
        if (currentStatus === 'active') {
          $btn.html('<i class="bi bi-pause-circle me-1"></i> Deactivate');
        } else {
          $btn.html('<i class="bi bi-play-circle me-1"></i> Activate');
        }
      }
    });
  });
});
</script>

<?php require_once __DIR__ . '/../../includes/admin_footer.php'; ?>
