<?php
require_once __DIR__.'/../../includes/admin_bootstrap.php';
if (!can_manage_drivers(get_current_role())) { http_response_code(403); exit('Forbidden'); }

// Filters
$q = trim($_GET['q'] ?? '');
$project_filter = isset($_GET['project']) && ctype_digit($_GET['project']) ? (int)$_GET['project'] : 0;
$status_filter = isset($_GET['status']) && in_array($_GET['status'], ['active', 'inactive'], true) ? $_GET['status'] : '';

$w = [];
$params = [];
$types = '';

if ($q !== '') {
  $w[] = "(d.partner_id LIKE CONCAT('%',?,'%') OR d.first_name LIKE CONCAT('%',?,'%') OR d.last_name LIKE CONCAT('%',?,'%') OR d.work_phone LIKE CONCAT('%',?,'%') OR d.personal_phone LIKE CONCAT('%',?,'%'))";
  array_push($params, $q, $q, $q, $q, $q);
  $types .= 'sssss';
}

if ($project_filter > 0) {
  $w[] = "d.project_id = ?";
  $params[] = $project_filter;
  $types .= 'i';
}

if ($status_filter !== '') {
  $w[] = "d.status = ?";
  $params[] = $status_filter;
  $types .= 's';
}

$where = $w ? ('WHERE '.implode(' AND ',$w)) : '';

// Get total count
$count_sql = "SELECT COUNT(*) as total FROM drivers d $where";
$count_stmt = $conn->prepare($count_sql);
if ($types) $count_stmt->bind_param($types, ...$params);
$count_stmt->execute();
$total_count = $count_stmt->get_result()->fetch_assoc()['total'];

// Fetch
$sql = "
  SELECT
    d.id,
    d.partner_id,
    d.first_name,
    d.last_name,
    d.work_phone,
    d.personal_phone,
    d.status,
    d.created_at,
    p.name  AS project_name,
    p.prefix AS project_prefix,
    c.name  AS city_name,
    (SELECT COUNT(*) FROM submissions WHERE driver_id = d.id AND status = 'approved') as approved_submissions,
    (SELECT COUNT(*) FROM driver_doc_sets WHERE driver_id = d.id AND status = 'approved') as approved_docs
  FROM drivers d
  LEFT JOIN projects p ON p.id = d.project_id
  LEFT JOIN cities   c ON c.id = d.city_id
  $where
  ORDER BY d.id DESC
  LIMIT 500
";
$st = $conn->prepare($sql);
if ($types) $st->bind_param($types, ...$params);
$st->execute();
$rows = $st->get_result()->fetch_all(MYSQLI_ASSOC);

// Get all projects for filter dropdown
$projects = $conn->query("SELECT id, name, prefix FROM projects ORDER BY name")->fetch_all(MYSQLI_ASSOC);

// Helper functions
function phone_html($num) {
  if (!$num) return '<span class="text-muted">-</span>';
  $n = preg_replace('/\D+/', '', $num);
  $tel = htmlspecialchars($num, ENT_QUOTES);
  return '
    <div class="d-flex align-items-center gap-2">
      <a href="tel:'.$tel.'" class="text-decoration-none text-dark" title="Call">
        <i class="bi bi-telephone-fill"></i>
      </a>
      <a href="https://wa.me/'.$n.'" target="_blank" class="text-success text-decoration-none" title="WhatsApp">
        <i class="bi bi-whatsapp"></i>
      </a>
      <span class="small">'.e($num).'</span>
    </div>
  ';
}

function status_badge($status) {
  $status = strtolower($status ?? 'active');
  if ($status === 'active') {
    return '<span class="badge bg-success">Active</span>';
  }
  return '<span class="badge bg-secondary">Inactive</span>';
}

$PAGE_TITLE = 'Drivers';
require_once __DIR__ . '/../../includes/admin_header.php';
?>

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

<style>
.driver-row {
  transition: all 0.2s;
}
.driver-row:hover {
  background-color: #f8f9fa;
  transform: scale(1.01);
  box-shadow: 0 2px 8px rgba(0,0,0,0.1);
}
.stat-badge {
  font-size: 0.75rem;
  padding: 0.25rem 0.5rem;
}
.driver-avatar-sm {
  width: 40px;
  height: 40px;
  border-radius: 50%;
  background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
  display: flex;
  align-items: center;
  justify-content: center;
  color: white;
  font-weight: 600;
  font-size: 0.875rem;
}
.filter-card {
  background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
  color: white;
}
.filter-card .form-control,
.filter-card .form-select {
  border: 1px solid rgba(255,255,255,0.3);
  background: rgba(255,255,255,0.9);
}
.stats-summary {
  background: linear-gradient(to right, #f8f9fa, #ffffff);
  border-left: 4px solid #dc3545;
}
</style>

<div class="d-flex justify-content-between align-items-start mb-4">
  <div>
    <h4 class="mb-1">Drivers Management</h4>
    <p class="text-muted small mb-0">Manage all drivers in the system</p>
  </div>
  <div class="d-flex gap-2">
    <a href="<?= base_url('admin/drivers_bulk_upload.php') ?>" class="btn btn-outline-primary btn-sm">
      <i class="bi bi-upload me-1"></i> Bulk Upload
    </a>
    <a href="<?= base_url('admin/driver_create.php') ?>" class="btn btn-primary btn-sm">
      <i class="bi bi-plus-circle me-1"></i> Create Driver
    </a>
  </div>
</div>

<!-- Stats Summary -->
<div class="card stats-summary shadow-sm mb-4">
  <div class="card-body py-3">
    <div class="row align-items-center">
      <div class="col-auto">
        <i class="bi bi-people-fill fs-3 text-danger"></i>
      </div>
      <div class="col">
        <div class="row g-3">
          <div class="col-auto">
            <div class="small text-muted">Total Drivers</div>
            <div class="h5 mb-0"><?= number_format($total_count) ?></div>
          </div>
          <div class="col-auto border-start">
            <div class="small text-muted">Filtered Results</div>
            <div class="h5 mb-0"><?= number_format(count($rows)) ?></div>
          </div>
          <?php if ($q !== '' || $project_filter > 0 || $status_filter !== ''): ?>
          <div class="col-auto">
            <a href="<?= base_url('admin/driver_list.php') ?>" class="btn btn-sm btn-outline-secondary">
              <i class="bi bi-x-circle me-1"></i> Clear Filters
            </a>
          </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Filters -->
<div class="card filter-card shadow-sm mb-4">
  <div class="card-body">
    <form method="get" class="row g-3">
      <div class="col-md-5">
        <label class="form-label small fw-bold">
          <i class="bi bi-search me-1"></i> Search
        </label>
        <input type="text" name="q" class="form-control" placeholder="Search by ID, name, or phone" value="<?= e($q) ?>">
      </div>
      <div class="col-md-3">
        <label class="form-label small fw-bold">
          <i class="bi bi-building me-1"></i> Project
        </label>
        <select name="project" class="form-select">
          <option value="">All Projects</option>
          <?php foreach ($projects as $proj): ?>
            <option value="<?= $proj['id'] ?>" <?= $project_filter === (int)$proj['id'] ? 'selected' : '' ?>>
              <?= e($proj['name']) ?> (<?= e($proj['prefix']) ?>)
            </option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-2">
        <label class="form-label small fw-bold">
          <i class="bi bi-circle-fill me-1"></i> Status
        </label>
        <select name="status" class="form-select">
          <option value="">All Status</option>
          <option value="active" <?= $status_filter === 'active' ? 'selected' : '' ?>>Active</option>
          <option value="inactive" <?= $status_filter === 'inactive' ? 'selected' : '' ?>>Inactive</option>
        </select>
      </div>
      <div class="col-md-2 d-flex align-items-end">
        <button class="btn btn-light w-100">
          <i class="bi bi-funnel-fill me-1"></i> Apply Filters
        </button>
      </div>
    </form>
  </div>
</div>

<!-- Drivers List -->
<div class="card shadow-sm">
  <div class="card-header bg-white">
    <h6 class="mb-0"><i class="bi bi-list-ul me-2"></i>Drivers List</h6>
  </div>
  <div class="card-body p-0">
    <?php if (!$rows): ?>
      <div class="text-center py-5">
        <i class="bi bi-inbox fs-1 text-muted"></i>
        <p class="text-muted mt-3 mb-0">No drivers found matching your criteria</p>
      </div>
    <?php else: ?>
      <div class="table-responsive">
        <table class="table table-hover align-middle mb-0">
          <thead class="table-light">
            <tr>
              <th style="width:80px;"></th>
              <th style="width:140px;">Driver ID</th>
              <th>Name</th>
              <th>Project</th>
              <th>City</th>
              <th>Work Phone</th>
              <th>Personal Phone</th>
              <th class="text-center">Status</th>
              <th class="text-center">Stats</th>
              <th class="text-end" style="width:180px;">Actions</th>
            </tr>
          </thead>
          <tbody>
          <?php foreach ($rows as $r): ?>
            <tr class="driver-row">
              <td>
                <div class="driver-avatar-sm">
                  <?= strtoupper(substr($r['first_name'] ?? 'D', 0, 1)) ?>
                </div>
              </td>
              <td>
                <span class="badge bg-light text-dark border"><?= e($r['partner_id']) ?></span>
              </td>
              <td>
                <div class="fw-semibold"><?= e(trim(($r['first_name'] ?? '').' '.($r['last_name'] ?? ''))) ?></div>
                <div class="small text-muted">
                  <i class="bi bi-calendar-plus me-1"></i>Joined <?= date('M Y', strtotime($r['created_at'])) ?>
                </div>
              </td>
              <td>
                <div><?= e($r['project_name'] ?? '-') ?></div>
                <?php if (!empty($r['project_prefix'])): ?>
                  <span class="badge bg-info bg-opacity-10 text-info stat-badge">
                    <?= e($r['project_prefix']) ?>
                  </span>
                <?php endif; ?>
              </td>
              <td><?= e($r['city_name'] ?? '-') ?></td>
              <td><?= phone_html($r['work_phone'] ?? '') ?></td>
              <td><?= phone_html($r['personal_phone'] ?? '') ?></td>
              <td class="text-center">
                <?= status_badge($r['status']) ?>
              </td>
              <td class="text-center">
                <div class="d-flex gap-1 justify-content-center">
                  <span class="badge bg-success bg-opacity-10 text-success stat-badge" title="Approved Submissions">
                    <i class="bi bi-file-check"></i> <?= $r['approved_submissions'] ?>
                  </span>
                  <span class="badge bg-warning bg-opacity-10 text-warning stat-badge" title="Approved Documents">
                    <i class="bi bi-file-earmark-check"></i> <?= $r['approved_docs'] ?>
                  </span>
                </div>
              </td>
              <td class="text-end">
                <div class="btn-group btn-group-sm">
                  <a class="btn btn-outline-secondary" href="<?= base_url('admin/driver_view.php?id='.(int)$r['id']) ?>" title="View Details">
                    <i class="bi bi-eye"></i>
                  </a>
                  <a class="btn btn-outline-primary" href="<?= base_url('admin/driver_edit.php?id='.(int)$r['id']) ?>" title="Edit Driver">
                    <i class="bi bi-pencil"></i>
                  </a>
                </div>
              </td>
            </tr>
          <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    <?php endif; ?>
  </div>
  <?php if (count($rows) >= 500): ?>
  <div class="card-footer bg-light">
    <div class="alert alert-warning mb-0 small">
      <i class="bi bi-exclamation-triangle me-2"></i>
      Showing first 500 results. Use filters to narrow down your search.
    </div>
  </div>
  <?php endif; ?>
</div>

<?php require_once __DIR__ . '/../../includes/admin_footer.php'; ?>
