<?php
require_once __DIR__.'/../../includes/admin_bootstrap.php';
$role = get_current_role();
$can_view   = can_view_lookups($role);
$can_manage = can_manage_lookups($role);

if (!$can_view) { http_response_code(403); exit('Forbidden'); }

// Block any create, edit, delete for non-managers
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !$can_manage) {
  http_response_code(403); exit('Forbidden');
}

// If you open edit screens via GET flags, also block them:
if ((isset($_GET['new']) || isset($_GET['edit']) || isset($_POST['delete_id'])) && !$can_manage) {
  http_response_code(403); exit('Forbidden');
}

if (!can_manage_lookups(current_user_role())) { http_response_code(403); exit('Forbidden'); }
require_once __DIR__.'/../../config/db.php';

$err = ''; $ok='';

if ($_SERVER['REQUEST_METHOD']==='POST') {
  $action = $_POST['action'] ?? '';
  if ($action==='create') {
    $name = trim($_POST['name'] ?? '');
    $prefix = strtoupper(trim($_POST['prefix'] ?? ''));
    if ($name==='' || $prefix==='') { $err='Name and prefix are required'; }
    elseif (!preg_match('/^[A-Z]{2,4}$/', $prefix)) { $err='Prefix must be 2-4 letters A-Z'; }
    else {
      $stmt = $conn->prepare('INSERT INTO projects(name,prefix) VALUES(?,?)');
      $stmt->bind_param('ss',$name,$prefix);
      if ($stmt->execute()) { $ok='Project created'; } else { $err='Failed: '.$conn->error; }
    }
  } elseif ($action==='update') {
    $id = (int)($_POST['id'] ?? 0);
    $name = trim($_POST['name'] ?? '');
    $prefix = strtoupper(trim($_POST['prefix'] ?? ''));
    if ($id<=0 || $name==='' || $prefix==='') { $err='All fields are required'; }
    elseif (!preg_match('/^[A-Z]{2,4}$/', $prefix)) { $err='Prefix must be 2-4 letters'; }
    else {
      $stmt = $conn->prepare('UPDATE projects SET name=?, prefix=? WHERE id=?');
      $stmt->bind_param('ssi',$name,$prefix,$id);
      if ($stmt->execute()) { $ok='Project updated'; } else { $err='Failed: '.$conn->error; }
    }
  }
}

$rows = $conn->query('SELECT id,name,prefix FROM projects ORDER BY name')->fetch_all(MYSQLI_ASSOC);
?>
<!doctype html><html><head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<title>Projects and Prefixes - Hisbuu</title>
</head><body class="bg-light">
<?php include __DIR__ . '/../../includes/admin_nav.php'; ?>

<div class="container py-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h5>Projects and prefixes</h5>
    <a href="<?php echo base_url('dashboard.php'); ?>" class="btn btn-outline-secondary btn-sm">Back</a>
  </div>
  <?php if($err): ?><div class="alert alert-danger"><?php echo e($err); ?></div><?php endif; ?>
  <?php if($ok): ?><div class="alert alert-success"><?php echo e($ok); ?></div><?php endif; ?>

  <div class="card mb-3"><div class="card-body">
    <form method="POST" class="row g-2">
      <input type="hidden" name="action" value="create">
      <div class="col-md-6">
        <label class="form-label">Project name</label>
        <input class="form-control" name="name" required>
      </div>
      <div class="col-md-3">
        <label class="form-label">Prefix</label>
        <input class="form-control" name="prefix" placeholder="TB" maxlength="4" required>
        <div class="form-text">2-4 letters, e.g., TB, TM, KD.</div>
      </div>
      <div class="col-md-3 align-self-end">
        <button class="btn btn-danger">Add project</button>
      </div>
    </form>
  </div></div>

  <div class="card"><div class="card-body p-0">
    <table class="table table-striped mb-0">
      <thead><tr><th>ID</th><th>Name</th><th>Prefix</th><th class="text-end">Actions</th></tr></thead>
      <tbody>
        <?php foreach($rows as $r): ?>
        <tr>
          <td><?php echo (int)$r['id']; ?></td>
          <td><?php echo e($r['name']); ?></td>
          <td><?php echo e($r['prefix']); ?></td>
          <td class="text-end">
            <button class="btn btn-sm btn-outline-primary" data-bs-toggle="collapse" data-bs-target="#e<?php echo (int)$r['id']; ?>">Edit</button>
          </td>
        </tr>
        <tr class="collapse" id="e<?php echo (int)$r['id']; ?>">
          <td colspan="4">
            <form method="POST" class="row g-2 p-3 bg-light border-top">
              <input type="hidden" name="action" value="update">
              <input type="hidden" name="id" value="<?php echo (int)$r['id']; ?>">
              <div class="col-md-6"><input class="form-control" name="name" value="<?php echo e($r['name']); ?>" required></div>
              <div class="col-md-3"><input class="form-control" name="prefix" value="<?php echo e($r['prefix']); ?>" maxlength="4" required></div>
              <div class="col-md-3"><button class="btn btn-primary w-100">Save</button></div>
            </form>
          </td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div></div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body></html>