<?php
require_once __DIR__.'/../../includes/admin_bootstrap.php';
$role=get_current_role();
if (!can_view_partner_daily($role)) { http_response_code(403); exit('Forbidden'); }
$id=(int)($_GET['id']??0); if($id<=0){ exit('Invalid id'); }
$q=$conn->prepare('SELECT pd.*, p.name project_name FROM partner_daily pd JOIN projects p ON p.id=pd.project_id WHERE pd.id=?'); $q->bind_param('i',$id); $q->execute(); $row=$q->get_result()->fetch_assoc();
$canEdit = can_reconcile_partner_daily($role);
?>
<!doctype html><html><head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<title>Resolve mismatch - Hisbuu</title></head>
<body class="bg-light">
<div class="container py-4" style="max-width:900px;">
  <a class="btn btn-outline-secondary btn-sm mb-3" href="reconcile_list.php?month=<?php echo e(date('Y-m', strtotime($row['service_date']))); ?>">Back</a>
  <div class="card"><div class="card-header">Resolve mismatch</div><div class="card-body">
    <div class="row g-3">
      <div class="col-md-3"><label class="form-label">Date</label><input class="form-control" value="<?php echo e($row['service_date']); ?>" disabled></div>
      <div class="col-md-4"><label class="form-label">Partner</label><input class="form-control" value="<?php echo e($row['partner_name']); ?>" disabled></div>
      <div class="col-md-2"><label class="form-label">Total orders</label><input class="form-control" value="<?php echo (int)$row['total_orders']; ?>" disabled></div>
      <div class="col-md-3"><label class="form-label">Total amount</label><input class="form-control" value="<?php echo number_format((float)$row['total_amount'],3); ?>" disabled></div>
      <div class="col-md-2"><label class="form-label">Matched orders</label><input class="form-control" value="<?php echo (int)$row['matched_orders']; ?>" disabled></div>
      <div class="col-md-3"><label class="form-label">Matched amount</label><input class="form-control" value="<?php echo number_format((float)$row['matched_amount'],3); ?>" disabled></div>
    </div>
    <hr>
    <form method="POST" action="reconcile_store.php" class="row g-3">
      <input type="hidden" name="id" value="<?php echo (int)$row['id']; ?>">
      <?php if ($canEdit): ?>
      <div class="col-md-3"><label class="form-label">Finance orders</label><input class="form-control" type="number" min="0" name="finance_orders" value="<?php echo e($row['finance_orders'] ?? ''); ?>"></div>
      <div class="col-md-3"><label class="form-label">Finance amount</label><input class="form-control" type="number" step="0.001" min="0" name="finance_amount" value="<?php echo e(isset($row['finance_amount']) ? number_format((float)$row['finance_amount'],3,'.','') : ''); ?>" placeholder="25.356"></div>
      <div class="col-md-6"><label class="form-label">Finance note</label><input class="form-control" name="finance_note" value="<?php echo e($row['finance_note'] ?? ''); ?>"></div>
      <div class="col-12 text-end">
        <button class="btn btn-primary" name="action" value="save">Save</button>
        <button class="btn btn-success" name="action" value="reconcile">Mark reconciled</button>
      </div>
      <?php else: ?><div class="alert alert-info">Read only for your role. Finance and Admin can edit.</div><?php endif; ?>
    </form>
  </div></div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body></html>