<?php
require_once __DIR__.'/../../includes/admin_bootstrap.php';
if (!can_review_submissions(get_current_role())) { http_response_code(403); exit('Forbidden'); }
$days = isset($_GET['days']) ? max(1,(int)$_GET['days']) : 3;
$end = date('Y-m-d'); $start = date('Y-m-d', strtotime("-$days days"));
$sql = "SELECT d.id, CONCAT(COALESCE(d.first_name,''),' ',COALESCE(d.last_name,'')) driver_name, d.partner_id,
               p.name project, c.name city,
               ls.last_date, la.last_approved
        FROM drivers d
        LEFT JOIN (SELECT driver_id, MAX(service_date) last_date FROM submissions GROUP BY driver_id) ls ON ls.driver_id=d.id
        LEFT JOIN (SELECT driver_id, MAX(service_date) last_approved FROM submissions WHERE status='approved' GROUP BY driver_id) la ON la.driver_id=d.id
        LEFT JOIN (SELECT driver_id, COUNT(*) c FROM submissions WHERE service_date>=? AND service_date<? GROUP BY driver_id) sw ON sw.driver_id=d.id
        LEFT JOIN projects p ON p.id=d.project_id
        LEFT JOIN cities c ON c.id=d.city_id
        WHERE d.status='active' AND sw.c IS NULL ORDER BY driver_name";
$stmt = $conn->prepare($sql);
$stmt->bind_param('ss', $start, $end);
$stmt->execute(); $rows = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
?>
<!doctype html><html><head>

<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<title>Submission gaps - Hisbuu</title>
</head><body class="bg-light">
<div class="container py-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h5>Submission gaps</h5>
    <a class="btn btn-outline-secondary btn-sm" href="/hisbuu/public/dashboard.php">Back</a>
  </div>
  <form class="row gy-2 gx-3 align-items-end mb-3" method="GET">
    <div class="col-auto"><label class="form-label">Lookback days</label><input class="form-control" type="number" min="1" max="31" name="days" value="<?php echo (int)$days; ?>"></div>
    <div class="col-auto"><button class="btn btn-primary">Apply</button></div>
  </form>
  <div class="card"><div class="card-body p-0">
    <table class="table table-striped mb-0">
      <thead><tr><th>Driver</th><th>UUID</th><th>Project</th><th>City</th><th>Last Submission</th><th>Last Approved</th></tr></thead>
      <tbody>
        <?php foreach ($rows as $r): ?>
        <tr>
          <td><?php echo e($r['driver_name']); ?></td>
          <td><?php echo e($r['partner_id']); ?></td>
          <td><?php echo e($r['project']); ?></td>
          <td><?php echo e($r['city']); ?></td>
          <td><?php echo e($r['last_date'] ?? '—'); ?></td>
          <td><?php echo e($r['last_approved'] ?? '—'); ?></td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div></div>
</div>
</body></html>
