<?php
// public/admin/users_manage.php
require_once __DIR__ . '/../../includes/admin_bootstrap.php';
if (!can_manage_users(get_current_role())) {
    http_response_code(403);
    exit('Forbidden');
}


$filter = $_GET['q'] ?? '';
$where = '1=1';
$params = []; $types='';
if ($filter !== '') { $where .= ' AND (email LIKE ? OR role LIKE ?)'; $params[]="%$filter%"; $params[]="%$filter%"; $types.='ss'; }

$sql = "SELECT id,email,role,status,created_at FROM users WHERE $where ORDER BY created_at DESC";
$stmt = $conn->prepare($sql);
if ($types) { $stmt->bind_param($types, ...$params); }
$stmt->execute();
$rows = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <title>Manage Users</title>
</head>
<body class="bg-light">
<?php @include __DIR__ . '/../../includes/admin_nav.php'; ?>
<div class="container py-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0">Users</h5>
    <a class="btn btn-danger btn-sm" href="users_new.php">Create user</a>
  </div>

  <form class="row g-2 mb-3" method="GET">
    <div class="col-auto">
      <input class="form-control" type="text" name="q" value="<?php echo htmlspecialchars($filter); ?>" placeholder="Search email or role">
    </div>
    <div class="col-auto">
      <button class="btn btn-outline-secondary">Search</button>
    </div>
  </form>

  <div class="card">
    <div class="table-responsive">
      <table class="table table-striped align-middle mb-0">
        <thead>
          <tr>
            <th>Email</th>
            <th>Role</th>
            <th>Status</th>
            <th>Created</th>
            <th class="text-end">Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php if (!$rows): ?>
            <tr><td colspan="5" class="text-muted">No users.</td></tr>
          <?php else: foreach ($rows as $u): ?>
            <tr>
              <td><?php echo htmlspecialchars($u['email']); ?></td>
              <td><?php echo htmlspecialchars($u['role']); ?></td>
              <td>
                <span class="badge bg-<?php echo $u['status']==='active'?'success':'secondary'; ?>">
                  <?php echo htmlspecialchars($u['status']); ?>
                </span>
              </td>
              <td><?php echo htmlspecialchars($u['created_at']); ?></td>
              <td class="text-end">
                <div class="btn-group btn-group-sm">
                  <?php if ($u['status']==='active'): ?>
                    <a class="btn btn-outline-secondary" href="users_toggle.php?id=<?php echo (int)$u['id']; ?>&action=disable">Disable</a>
                  <?php else: ?>
                    <a class="btn btn-outline-success" href="users_toggle.php?id=<?php echo (int)$u['id']; ?>&action=enable">Enable</a>
                  <?php endif; ?>
                  <a class="btn btn-outline-primary" href="users_reset.php?id=<?php echo (int)$u['id']; ?>">Reset password</a>
                </div>
              </td>
            </tr>
          <?php endforeach; endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
