<?php
// public/admin/users_new.php
require_once __DIR__ . '/../../includes/admin_bootstrap.php';
if (!can_manage_users(get_current_role())) {
    http_response_code(403);
    exit('Forbidden');
}


$err = $_GET['err'] ?? '';
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <title>Create User</title>
</head>
<body class="bg-light">
<?php @include __DIR__ . '/../../includes/admin_nav.php'; ?>
<div class="container py-4" style="max-width:640px">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0">Create user</h5>
    <a class="btn btn-outline-secondary btn-sm" href="users_manage.php">Back</a>
  </div>

  <?php if ($err): ?><div class="alert alert-danger"><?php echo htmlspecialchars($err); ?></div><?php endif; ?>

  <div class="card"><div class="card-body">
    <form method="POST" action="users_store.php">
      <div class="mb-3">
        <label class="form-label">Email</label>
        <input type="email" class="form-control" name="email" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Role</label>
        <select class="form-select" name="role" required>
          <option value="Administrator">Administrator</option>
          <option value="Finance Administrator">Finance Administrator</option>
          <option value="Supervisor">Supervisor</option>
        </select>
      </div>
      <div class="mb-3">
        <label class="form-label">Temp password</label>
        <input type="text" class="form-control" name="password" placeholder="e.g., Abcd@123" required>
        <div class="form-text">The user will change it after first login.</div>
      </div>
      <div class="text-end">
        <button class="btn btn-danger">Create user</button>
      </div>
    </form>
  </div></div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
