<?php
// public/admin/users_store.php
require_once __DIR__ . '/../../includes/admin_bootstrap.php';
if (!can_manage_users(get_current_role())) { http_response_code(403); exit('Forbidden'); }

$email = trim($_POST['email'] ?? '');
$role  = trim($_POST['role'] ?? '');
$pass  = $_POST['password'] ?? '';

$allowed = ['Administrator','Finance Administrator','Supervisor'];
if ($email === '' || $pass === '' || !in_array($role, $allowed, true)) {
  header('Location: users_new.php?err=' . urlencode('Invalid input.')); exit;
}

$hash = password_hash($pass, PASSWORD_BCRYPT);

try {
  $stmt = $conn->prepare('INSERT INTO users (email,password_hash,role,status) VALUES (?,?,?, "active")');
  $stmt->bind_param('sss', $email, $hash, $role);
  $stmt->execute();
  header('Location: users_manage.php'); exit;
} catch (Throwable $e) {
  header('Location: users_new.php?err=' . urlencode('Failed: ' . $e->getMessage())); exit;
}
