<?php
// public/admin/users_toggle.php
require_once __DIR__ . '/../../includes/admin_bootstrap.php';
if (!can_manage_users(get_current_role())) { http_response_code(403); exit('Forbidden'); }

$id = (int)($_GET['id'] ?? 0);
$action = $_GET['action'] ?? '';
if ($id <= 0 || !in_array($action, ['enable','disable'], true)) { http_response_code(400); exit('Bad request'); }

$status = $action === 'enable' ? 'active' : 'disabled';
$stmt = $conn->prepare('UPDATE users SET status=? WHERE id=?');
$stmt->bind_param('si', $status, $id);
$stmt->execute();
header('Location: users_manage.php');
exit;
