<?php
// public/admin/zones_by_city.php
require_once __DIR__ . '/../../includes/admin_bootstrap.php';
// Anyone who can view driver forms should at least view lookups
if (!can_view_lookups(get_current_role())) {
  http_response_code(403);
  exit('Forbidden');
}

header('Content-Type: text/html; charset=utf-8');

$city_id = isset($_GET['city_id']) && ctype_digit($_GET['city_id']) ? (int)$_GET['city_id'] : 0;

if ($city_id <= 0) {
  echo '<option value="">Select zone</option>';
  exit;
}

$stmt = $conn->prepare("SELECT id, name FROM zones WHERE city_id=? ORDER BY name");
$stmt->bind_param('i', $city_id);
$stmt->execute();
$res = $stmt->get_result();

echo '<option value="">Select zone</option>';
while ($r = $res->fetch_assoc()) {
  printf('<option value="%d">%s</option>', (int)$r['id'], htmlspecialchars($r['name'], ENT_QUOTES, 'UTF-8'));
}
