<?php
// Save as /hisbuu/public/dev/check_driver.php
require_once __DIR__ . '/../../config/db.php';
function e($s){ return htmlspecialchars((string)$s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }
$uuid = isset($_GET['uuid']) ? $_GET['uuid'] : 'F/A-0001';
$pass = isset($_GET['pass']) ? $_GET['pass'] : 'demo123';
$stmt = $conn->prepare('SELECT id, first_name, last_name, login_password FROM drivers WHERE partner_id=?');
$stmt->bind_param('s', $uuid);
$stmt->execute();
$res = $stmt->get_result();
header('Content-Type: text/html; charset=utf-8');
echo '<!doctype html><html><head><meta charset="utf-8"><link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"></head><body class="p-4"><div class="container" style="max-width:720px">';
echo '<h5>Driver password check</h5>';
if (!$row = $res->fetch_assoc()) {
  echo '<div class="alert alert-danger">No driver found for UUID: '.e($uuid).'</div>';
} else {
  $name = trim(($row['first_name']??'').' '.($row['last_name']??''));
  $hash = (string)($row['login_password'] ?? '');
  $ok = (!empty($hash) && password_verify($pass, $hash));
  echo '<table class="table table-sm"><tr><th>UUID</th><td>'.e($uuid).'</td></tr>';
  echo '<tr><th>Name</th><td>'.e($name).'</td></tr>';
  echo '<tr><th>Hash present</th><td>'.(empty($hash)?'<span class="text-danger">NO</span>':'<span class="text-success">YES</span>').'</td></tr>';
  echo '<tr><th>Hash algo hint</th><td>'.(empty($hash)?'n/a':e(substr($hash,0,4))).'</td></tr>';
  echo '<tr><th>Verify result</th><td>'.($ok?'<span class="badge bg-success">OK</span>':'<span class="badge bg-danger">FAIL</span>').'</td></tr></table>';
}
echo '<hr><form method="GET" class="row g-2"><div class="col-md-5"><input class="form-control" name="uuid" placeholder="UUID" value="'.e($uuid).'"></div><div class="col-md-5"><input class="form-control" name="pass" placeholder="Password" value="'.e($pass).'"></div><div class="col-md-2"><button class="btn btn-secondary w-100">Test</button></div></form>';
echo '<p class="mt-3">To set a fresh password with PHP hashing, open <a href="set_driver_password.php">set_driver_password.php</a>.</p>';
echo '</div></body></html>';