<?php
// public/driver/fix_indexes.php
ini_set('display_errors', 1);
error_reporting(E_ALL);
require_once __DIR__ . '/../../config/db.php';

echo "<h2>Database Index Repair</h2><pre>";

// 1. Drop the old restrictive index
try {
    echo "Attempting to drop old index 'uk_driver_doc' (prevents multiple sides)... ";
    // We try both common names just in case
    try { $conn->query("ALTER TABLE driver_documents DROP INDEX uk_driver_doc"); } catch(Exception $e){}
    try { $conn->query("ALTER TABLE driver_documents DROP INDEX uniq_driver_type"); } catch(Exception $e){}
    
    echo "<span style='color:green'>DONE (Old constraints removed)</span>\n";
} catch (Exception $e) {
    echo "Info: " . $e->getMessage() . "\n";
}

// 2. Add the new correct index (Driver + Type + Side)
try {
    echo "Adding new smart index (Driver + Type + Side)... ";
    $conn->query("ALTER TABLE driver_documents ADD UNIQUE KEY uk_driver_doc_side (driver_id, doc_type_id, side)");
    echo "<span style='color:green'>SUCCESS</span>\n";
} catch (Exception $e) {
    echo "Info (Index likely exists): " . $e->getMessage() . "\n";
}

echo "</pre>";
echo "<h3><a href='kyd_manage.php'>Repair Complete. Try Uploading Now.</a></h3>";
?>