<?php
require_once __DIR__ . '/../../includes/driver_bootstrap.php';

$driver_id = get_current_driver_id();
$currentMonth = date('Y-m');
$month = trim($_GET['month'] ?? $currentMonth);
if (!preg_match('/^\d{4}-\d{2}$/', $month)) {
    $month = $currentMonth;
}
$start = $month . '-01';
$end   = date('Y-m-t', strtotime($start));
$monthLabel = DateTime::createFromFormat('Y-m-d', $start);
$monthLabel = $monthLabel ? $monthLabel->format('F Y') : $month;

// Data
$sq = $conn->prepare("
  SELECT id, service_date, orders_count, cash_deposited, trx_no, status, created_at
  FROM submissions
  WHERE driver_id=? AND service_date BETWEEN ? AND ?
  ORDER BY service_date DESC, id DESC
");
$sq->bind_param('iss', $driver_id, $start, $end);
$sq->execute();
$rows = $sq->get_result()->fetch_all(MYSQLI_ASSOC);
$total = count($rows);

function badge($s) {
  $s = strtolower((string)$s);
  if ($s === 'approved') return '<span class="badge text-bg-success">Approved</span>';
  if ($s === 'rejected') return '<span class="badge text-bg-danger">Rejected</span>';
  return '<span class="badge text-bg-warning text-dark">Pending</span>';
}

$title = 'All submissions';
require_once __DIR__ . '/../../includes/driver_ui_start.php';
?>
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0">All submissions</h5>
    <div class="small text-muted">Showing <?php echo (int)$total; ?> record(s) for <?php echo e($monthLabel); ?></div>
  </div>

  <div class="card mb-3">
    <div class="card-body">
      <form class="row g-2 align-items-end" method="get">
        <div class="col-sm-4 col-md-3">
          <label class="form-label small text-uppercase text-muted">Month</label>
          <input type="month" name="month" class="form-control form-control-sm" value="<?php echo e($month); ?>">
        </div>
        <div class="col-auto">
          <button class="btn btn-outline-secondary btn-sm">Apply</button>
          <?php if ($month !== $currentMonth): ?>
            <a class="btn btn-link btn-sm" href="my_submissions.php">Reset</a>
          <?php endif; ?>
        </div>
      </form>
    </div>
  </div>

  <div class="card mb-3">
    <div class="card-body">
      <div class="table-responsive">
        <table class="table table-sm align-middle">
          <thead class="table-light">
            <tr>
              <th class="text-nowrap">Date</th>
              <th class="text-end">Orders</th>
              <th class="text-end">Cash (OMR)</th>
              <th>TRX</th>
              <th>Status</th>
              <th class="text-nowrap">Submitted</th>
              <th class="text-end">Action</th>
            </tr>
          </thead>
          <tbody>
          <?php if (!$rows): ?>
            <tr><td colspan="7" class="text-muted">No records.</td></tr>
          <?php else: foreach ($rows as $r): ?>
            <?php
              $sid = (int)$r['id'];
              $stat = strtolower($r['status'] ?? 'pending');
              $can_resubmit = in_array($stat, ['pending','rejected'], true);
            ?>
            <tr>
              <td class="text-nowrap"><?php echo e($r['service_date']); ?></td>
              <td class="text-end"><?php echo (int)$r['orders_count']; ?></td>
              <td class="text-end"><?php echo number_format((float)$r['cash_deposited'], 3, '.', ''); ?></td>
              <td class="text-nowrap"><?php echo e($r['trx_no'] ?: ''); ?></td>
              <td><?php echo badge($stat); ?></td>
              <td class="text-nowrap"><?php echo e($r['created_at']); ?></td>
              <td class="text-end">
                <?php if ($can_resubmit): ?>
                  <a class="btn btn-outline-primary btn-sm" href="<?php echo base_url('driver/resubmit.php'); ?>?id=<?php echo $sid; ?>">Resubmit</a>
                <?php else: ?>
                  <button class="btn btn-outline-secondary btn-sm" disabled>Resubmit</button>
                <?php endif; ?>
              </td>
            </tr>
          <?php endforeach; endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
<?php
require_once __DIR__ . '/../../includes/driver_ui_end.php';
