<?php
// public/driver/payouts_list.php
// List of payouts for the logged in driver

require_once __DIR__ . '/../../includes/driver_bootstrap.php';

$title = 'My payouts';
require_once __DIR__ . '/../../includes/driver_ui_start.php';

// driver_ui_start.php already started the session, loaded DB and enforced driver login + KYD
$driver_id = get_current_driver_id();
if ($driver_id <= 0) {
    die('Driver session not set.');
}

$sql = "
    SELECT
      pc.id          AS cycle_id,
      pc.cycle_month,
      pc.period_start,
      pc.period_end,
      pc.status,
      pi.net_payout,
      pi.updated_at,
      pi.created_at
    FROM payout_items pi
    JOIN payout_cycles pc ON pc.id = pi.cycle_id
    WHERE pi.driver_id = ?
    ORDER BY pc.period_start DESC
";

$stmt = $conn->prepare($sql);
$stmt->bind_param('i', $driver_id);
$stmt->execute();
$res  = $stmt->get_result();
$rows = [];
while ($r = $res->fetch_assoc()) {
    $rows[] = $r;
}
$stmt->close();
?>

<div class="mb-4" style="max-width: 640px; margin: 0 auto;">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="mb-0">My payouts</h4>
  </div>

  <?php if (!$rows): ?>
    <div class="alert alert-info py-2">
      No payouts found yet.
    </div>
  <?php else: ?>
    <?php foreach ($rows as $r): ?>
      <?php
        $status    = $r['status'];
        $payout    = (float)$r['net_payout'];
        $updatedAt = $r['updated_at'] ?: $r['created_at'];

        $badgeClass = 'bg-secondary';
        if ($status === 'locked') {
            $badgeClass = 'bg-info';
        } elseif ($status === 'paid') {
            $badgeClass = 'bg-success';
        }
      ?>
      <a href="payout_view.php?cycle_id=<?php echo (int)$r['cycle_id']; ?>"
         class="text-decoration-none text-reset">
        <div class="card mb-2 shadow-sm border-0">
          <div class="card-body py-2">
            <div class="d-flex justify-content-between align-items-center">
              <div>
                <div class="fw-semibold">
                  <?php echo e($r['cycle_month']); ?>
                </div>
                <div class="small text-muted">
                  <?php echo e($r['period_start']); ?> to <?php echo e($r['period_end']); ?>
                </div>
              </div>
              <div class="text-end">
                <div class="fw-semibold">
                  <?php echo number_format($payout, 3); ?> OMR
                </div>
                <div class="small text-muted">
                  Updated <?php echo e(substr($updatedAt, 0, 10)); ?>
                </div>
              </div>
            </div>
            <div class="mt-2 d-flex justify-content-between align-items-center">
              <span class="badge <?php echo $badgeClass; ?>">
                <?php echo ucfirst($status); ?>
              </span>
              <span class="small text-muted">Tap to view details</span>
            </div>
          </div>
        </div>
      </a>
    <?php endforeach; ?>
  <?php endif; ?>
</div>

</div> <!-- close container from driver_ui_start.php -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
