<?php
// public/driver/preview.php
require_once __DIR__ . '/../../includes/driver_auth.php';
require_once __DIR__ . '/../../includes/constants.php';
require_once __DIR__ . '/../../config/db.php';
require_driver_login();

$driver_id = current_driver_id();
$subm_id = (int)($_GET['id'] ?? 0);
$slot = $_GET['slot'] ?? 'ss_orders'; // ss_orders | ss_deposit_1 | ss_deposit_2
$allowed = ['ss_orders','ss_deposit_1','ss_deposit_2'];
if ($subm_id <= 0 || !in_array($slot, $allowed, true)) {
  http_response_code(400);
  echo 'Bad request';
  exit;
}

// Verify submission belongs to current driver and get filename
$sql = "SELECT $slot AS fname FROM submissions WHERE id=? AND driver_id=? LIMIT 1";
$stmt = $conn->prepare($sql);
$stmt->bind_param('ii', $subm_id, $driver_id);
$stmt->execute();
$row = $stmt->get_result()->fetch_assoc();
if (!$row || empty($row['fname'])) {
  http_response_code(404);
  echo 'File not found';
  exit;
}

$stored_path = $row['fname'];
$path = null;
$base = null;

// Handle new storage paths (storage/submissions/...)
if (preg_match('~^storage/submissions/(.+)$~', $stored_path, $m)) {
    $path = realpath(STORAGE_DIR . '/submissions/' . $m[1]);
    $base = realpath(STORAGE_DIR . '/submissions');
}
// Handle legacy paths (just filename in /storage/submissions/)
elseif (!str_contains($stored_path, '/')) {
    $path = realpath(STORAGE_DIR . '/submissions/' . $stored_path);
    $base = realpath(STORAGE_DIR . '/submissions');
}
// Handle old /uploads/ paths that might still be in DB
elseif (preg_match('~^/?uploads/(.+)$~', $stored_path, $m)) {
    $path = realpath(__DIR__ . '/../uploads/' . $m[1]);
    $base = realpath(__DIR__ . '/../uploads');
}

// Ensure the resolved path is inside the allowed directory
if ($path === false || $base === false || strpos($path, $base) !== 0 || !is_file($path)) {
  http_response_code(404);
  echo 'File not found';
  exit;
}

// Detect mime
$finfo = finfo_open(FILEINFO_MIME_TYPE);
$mime = finfo_file($finfo, $path) ?: 'application/octet-stream';
finfo_close($finfo);

header('Content-Type: ' . $mime);
header('Content-Length: ' . filesize($path));
header('Cache-Control: private, max-age=600');
readfile($path);
exit;