<?php
require_once __DIR__.'/../../includes/driver_bootstrap.php';

$driverId = get_current_driver_id();
$service_date = $_POST['service_date'] ?? '';
$orders_count = (int)($_POST['orders_count'] ?? 0);
$cash_deposited = (float)($_POST['cash_deposited'] ?? 0);
$remarks = trim($_POST['remarks'] ?? '');

$dir = __DIR__.'/../../storage/submissions';
if (!is_dir($dir)) { mkdir($dir, 0775, true); }

function save_img($key, $driverId, $date){
  if (empty($_FILES[$key]['name'])) return null;
  $f = $_FILES[$key];
  if ($f['error'] !== UPLOAD_ERR_OK) return null;
  $allowed = ['image/jpeg'=>'jpg','image/png'=>'png','image/webp'=>'webp'];
  $type = mime_content_type($f['tmp_name']);
  if (!isset($allowed[$type])) return null;
  $ext = $allowed[$type];
  $name = 'd'.$driverId.'_'.$date.'_'.$key.'_'.bin2hex(random_bytes(4)).'.'.$ext;
  $dest = __DIR__.'/../../storage/submissions/'.$name;
  if (move_uploaded_file($f['tmp_name'], $dest)) return $name;
  return null;
}

$ss_orders = save_img('ss_orders', $driverId, $service_date);
if (!$ss_orders) { exit('Orders screenshot required'); }
$ss_deposit_1 = save_img('ss_deposit_1', $driverId, $service_date);
$ss_deposit_2 = save_img('ss_deposit_2', $driverId, $service_date);

$sql = 'INSERT INTO submissions (driver_id,service_date,orders_count,cash_deposited,ss_orders,ss_deposit_1,ss_deposit_2,remarks,status)
        VALUES (?,?,?,?,?,?,?,?,"pending")
        ON DUPLICATE KEY UPDATE orders_count=VALUES(orders_count), cash_deposited=VALUES(cash_deposited), ss_orders=VALUES(ss_orders), ss_deposit_1=VALUES(ss_deposit_1), ss_deposit_2=VALUES(ss_deposit_2), remarks=VALUES(remarks), status="pending", updated_at=NOW()';
$stmt = $conn->prepare($sql);
$stmt->bind_param('isisssss', $driverId, $service_date, $orders_count, $cash_deposited, $ss_orders, $ss_deposit_1, $ss_deposit_2, $remarks);
$stmt->execute();

// Auto recalc partner_daily
$proj = $conn->prepare('SELECT project_id FROM drivers WHERE id=?');
$proj->bind_param('i',$driverId); $proj->execute(); $d = $proj->get_result()->fetch_assoc();
if ($d) {
  $pname = $conn->prepare('SELECT name FROM projects WHERE id=?');
  $pname->bind_param('i',$d['project_id']); $pname->execute(); $pn = $pname->get_result()->fetch_assoc();
  if ($pn) {
    $ins = $conn->prepare('INSERT IGNORE INTO partner_daily(service_date,project_id,partner_name,total_orders,total_amount) VALUES (?,?,?,?,0)');
    $zero = 0; $ins->bind_param('sisi',$service_date,$d['project_id'],$pn['name'],$zero); $ins->execute();
    $row = $conn->prepare('SELECT id FROM partner_daily WHERE service_date=? AND project_id=?');
    $row->bind_param('si',$service_date,$d['project_id']); $row->execute(); $pd = $row->get_result()->fetch_assoc();
    if ($pd) {
      $sum = $conn->prepare('SELECT COALESCE(SUM(s.orders_count),0) so, COALESCE(SUM(s.cash_deposited),0) sc FROM submissions s JOIN drivers d ON d.id=s.driver_id WHERE d.project_id=? AND s.service_date=?');
      $sum->bind_param('is',$d['project_id'],$service_date); $sum->execute(); $agg = $sum->get_result()->fetch_assoc();
      $mo = (int)($agg['so'] ?? 0); $ma = (float)($agg['sc'] ?? 0);
      $st = ($mo>0 || $ma>0) ? 'awaiting_approval' : 'yet_to_pay';
      $upd = $conn->prepare('UPDATE partner_daily SET matched_orders=?, matched_amount=?, status=? WHERE id=?');
      $upd->bind_param('idsi',$mo,$ma,$st,$pd['id']); $upd->execute();
    }
  }
}

header('Location: my_submissions.php');
