const CACHE_NAME = 'hisbuu-v2';

const ASSETS_TO_CACHE = [
  '/public/driver/offline.html',
  '/public/driver/manifest.json',
  '/public/driver/icons/icon-192.png',
  '/public/driver/icons/icon-512.png'
];

// Install SW and cache essentials
self.addEventListener('install', event => {
  event.waitUntil(
    caches.open(CACHE_NAME).then(cache => cache.addAll(ASSETS_TO_CACHE))
  );
  self.skipWaiting();
});

// Activate SW immediately
self.addEventListener('activate', event => {
  event.waitUntil(self.clients.claim());
});

// SAFE FETCH HANDLER
// Makes sure:
// - Your preloader never conflicts
// - No blank screens
// - No 503 errors
// - Offline.html shows only when needed
self.addEventListener('fetch', event => {

  // If user is offline AND navigating to a page
  if (!navigator.onLine && event.request.mode === 'navigate') {
    event.respondWith(
      caches.match('/public/driver/offline.html')
    );
    return;
  }

  // Always allow normal fetch
  // Never override CSS, JS, images
});
