<?php
// public/driver/view.php
require_once __DIR__ . '/../../includes/driver_bootstrap.php';

$driver_id = get_current_driver_id();

// Accept either ?id=123 or ?date=YYYY-MM-DD
$submission = null;
if (isset($_GET['id']) && ctype_digit($_GET['id'])) {
  $id = (int)$_GET['id'];
  $stmt = $conn->prepare("SELECT * FROM submissions WHERE id=? AND driver_id=? LIMIT 1");
  $stmt->bind_param('ii', $id, $driver_id);
  $stmt->execute();
  $submission = $stmt->get_result()->fetch_assoc();
} elseif (!empty($_GET['date'])) {
  $date = trim($_GET['date']);
  $stmt = $conn->prepare("SELECT * FROM submissions WHERE service_date=? AND driver_id=? LIMIT 1");
  $stmt->bind_param('si', $date, $driver_id);
  $stmt->execute();
  $submission = $stmt->get_result()->fetch_assoc();
}

if (!$submission) {
  http_response_code(404);
  ?>
  <!doctype html>
  <html lang="en"><head>
    <meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Not found</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  </head><body class="bg-light">
  <?php @include __DIR__ . '/../../includes/driver_nav.php'; ?>
  <div class="container py-5" style="max-width:900px;">
    <div class="alert alert-danger">Submission not found.</div>
    <a href="dashboard.php" class="btn btn-outline-secondary">Back to dashboard</a>
  </div>
  </body></html>
  <?php
  exit;
}

// Normalized fields
$service_date   = $submission['service_date'] ?? '';
$orders_count   = (int)($submission['orders_count'] ?? 0);
$cash_deposited = isset($submission['cash_deposited']) ? number_format((float)$submission['cash_deposited'], 3) : '0.000';
$status         = $submission['status'] ?? '';
$remarks        = $submission['remarks'] ?? '';
$created_at     = $submission['created_at'] ?? '';
$updated_at     = $submission['updated_at'] ?? '';

// Screenshot paths, support both schemas
$ss_orders   = $submission['ss_orders']          ?? ($submission['screenshot_1_path'] ?? null);
$ss_deposit1 = $submission['ss_deposit_1']       ?? ($submission['screenshot_2_path'] ?? null);
$ss_deposit2 = $submission['ss_deposit_2']       ?? ($submission['screenshot_3_path'] ?? null);

function badge($status){
  $map = ['approved'=>'success', 'pending'=>'warning', 'rejected'=>'danger'];
  $cls = $map[$status] ?? 'secondary';
  return '<span class="badge bg-'.$cls.'">'.h($status).'</span>';
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
  <title>View submission</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    .kv{font-size:.9rem;color:#6c757d}
  </style>
</head>
<body class="bg-light">
<?php @include __DIR__ . '/../../includes/driver_nav.php'; ?>

<div class="container py-4" style="max-width:900px;">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0">Submission for <?php echo h($service_date); ?></h5>
    <div><?php echo badge($status); ?></div>
  </div>

  <div class="card shadow-sm mb-3">
    <div class="card-body">
      <div class="row g-3">
        <div class="col-md-3">
          <div class="kv">Orders</div>
          <div class="fw-semibold"><?php echo $orders_count; ?></div>
        </div>
        <div class="col-md-3">
          <div class="kv">Cash, OMR</div>
          <div class="fw-semibold"><?php echo $cash_deposited; ?></div>
        </div>
        <div class="col-md-3">
          <div class="kv">Submitted at</div>
          <div class="fw-semibold"><?php echo h($created_at); ?></div>
        </div>
        <div class="col-md-3">
          <div class="kv">Updated at</div>
          <div class="fw-semibold"><?php echo h($updated_at); ?></div>
        </div>
        <div class="col-12">
          <div class="kv mb-1">Remarks</div>
          <div class="border rounded p-2" style="min-height:48px;"><?php echo nl2br(h($remarks)); ?></div>
        </div>
      </div>
    </div>
  </div>

  <div class="card shadow-sm">
    <div class="card-body">
      <div class="fw-semibold mb-2">Attachments</div>
      <ul class="list-unstyled mb-0">
        <li class="mb-2">
          <div class="kv">Order details</div>
          <?php if ($ss_orders): ?>
            <a target="_blank" href="<?php echo h($ss_orders); ?>" class="link-primary">Open file</a>
          <?php else: ?>
            <span class="text-muted">No file</span>
          <?php endif; ?>
        </li>
        <li class="mb-2">
          <div class="kv">Deposit slip 1</div>
          <?php if ($ss_deposit1): ?>
            <a target="_blank" href="<?php echo h($ss_deposit1); ?>" class="link-primary">Open file</a>
          <?php else: ?>
            <span class="text-muted">No file</span>
          <?php endif; ?>
        </li>
        <li>
          <div class="kv">Deposit slip 2</div>
          <?php if ($ss_deposit2): ?>
            <a target="_blank" href="<?php echo h($ss_deposit2); ?>" class="link-primary">Open file</a>
          <?php else: ?>
            <span class="text-muted">No file</span>
          <?php endif; ?>
        </li>
      </ul>
      <div class="mt-3">
        <a href="dashboard.php" class="btn btn-outline-secondary btn-sm">Back to dashboard</a>
        <?php if (in_array($status, ['pending','rejected'], true)): ?>
          <a href="submit.php?date=<?php echo h($service_date); ?>&mode=resubmit" class="btn btn-danger btn-sm">Resubmit</a>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
